/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminAsyncClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListTelemetryRulesForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryRuleSummary;

public class ListTelemetryRulesForOrganizationPublisher
implements SdkPublisher<ListTelemetryRulesForOrganizationResponse> {
    private final ObservabilityAdminAsyncClient client;
    private final ListTelemetryRulesForOrganizationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTelemetryRulesForOrganizationPublisher(ObservabilityAdminAsyncClient client, ListTelemetryRulesForOrganizationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTelemetryRulesForOrganizationPublisher(ObservabilityAdminAsyncClient client, ListTelemetryRulesForOrganizationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTelemetryRulesForOrganizationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTelemetryRulesForOrganizationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TelemetryRuleSummary> telemetryRuleSummaries() {
        Function<ListTelemetryRulesForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.telemetryRuleSummaries() != null) {
                return response.telemetryRuleSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTelemetryRulesForOrganizationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTelemetryRulesForOrganizationResponseFetcher
    implements AsyncPageFetcher<ListTelemetryRulesForOrganizationResponse> {
        private ListTelemetryRulesForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(ListTelemetryRulesForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTelemetryRulesForOrganizationResponse> nextPage(ListTelemetryRulesForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return ListTelemetryRulesForOrganizationPublisher.this.client.listTelemetryRulesForOrganization(ListTelemetryRulesForOrganizationPublisher.this.firstRequest);
            }
            return ListTelemetryRulesForOrganizationPublisher.this.client.listTelemetryRulesForOrganization((ListTelemetryRulesForOrganizationRequest)((Object)ListTelemetryRulesForOrganizationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

