/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminAsyncClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfiguration;

public class ListResourceTelemetryPublisher
implements SdkPublisher<ListResourceTelemetryResponse> {
    private final ObservabilityAdminAsyncClient client;
    private final ListResourceTelemetryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceTelemetryPublisher(ObservabilityAdminAsyncClient client, ListResourceTelemetryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceTelemetryPublisher(ObservabilityAdminAsyncClient client, ListResourceTelemetryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceTelemetryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceTelemetryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TelemetryConfiguration> telemetryConfigurations() {
        Function<ListResourceTelemetryResponse, Iterator> getIterator = response -> {
            if (response != null && response.telemetryConfigurations() != null) {
                return response.telemetryConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceTelemetryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceTelemetryResponseFetcher
    implements AsyncPageFetcher<ListResourceTelemetryResponse> {
        private ListResourceTelemetryResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceTelemetryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceTelemetryResponse> nextPage(ListResourceTelemetryResponse previousPage) {
            if (previousPage == null) {
                return ListResourceTelemetryPublisher.this.client.listResourceTelemetry(ListResourceTelemetryPublisher.this.firstRequest);
            }
            return ListResourceTelemetryPublisher.this.client.listResourceTelemetry((ListResourceTelemetryRequest)((Object)ListResourceTelemetryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

