/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfiguration;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceTelemetryForOrganizationResponse
extends ObservabilityAdminResponse
implements ToCopyableBuilder<Builder, ListResourceTelemetryForOrganizationResponse> {
    private static final SdkField<List<TelemetryConfiguration>> TELEMETRY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TelemetryConfigurations").getter(ListResourceTelemetryForOrganizationResponse.getter(ListResourceTelemetryForOrganizationResponse::telemetryConfigurations)).setter(ListResourceTelemetryForOrganizationResponse.setter(Builder::telemetryConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TelemetryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceTelemetryForOrganizationResponse.getter(ListResourceTelemetryForOrganizationResponse::nextToken)).setter(ListResourceTelemetryForOrganizationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEMETRY_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourceTelemetryForOrganizationResponse.memberNameToFieldInitializer();
    private final List<TelemetryConfiguration> telemetryConfigurations;
    private final String nextToken;

    private ListResourceTelemetryForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.telemetryConfigurations = builder.telemetryConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTelemetryConfigurations() {
        return this.telemetryConfigurations != null && !(this.telemetryConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TelemetryConfiguration> telemetryConfigurations() {
        return this.telemetryConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTelemetryConfigurations() ? this.telemetryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceTelemetryForOrganizationResponse)) {
            return false;
        }
        ListResourceTelemetryForOrganizationResponse other = (ListResourceTelemetryForOrganizationResponse)((Object)obj);
        return this.hasTelemetryConfigurations() == other.hasTelemetryConfigurations() && Objects.equals(this.telemetryConfigurations(), other.telemetryConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceTelemetryForOrganizationResponse").add("TelemetryConfigurations", this.hasTelemetryConfigurations() ? this.telemetryConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TelemetryConfigurations": {
                return Optional.ofNullable(clazz.cast(this.telemetryConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TelemetryConfigurations", TELEMETRY_CONFIGURATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceTelemetryForOrganizationResponse, T> g) {
        return obj -> g.apply((ListResourceTelemetryForOrganizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ObservabilityAdminResponse.BuilderImpl
    implements Builder {
        private List<TelemetryConfiguration> telemetryConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceTelemetryForOrganizationResponse model) {
            super(model);
            this.telemetryConfigurations(model.telemetryConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<TelemetryConfiguration.Builder> getTelemetryConfigurations() {
            List<TelemetryConfiguration.Builder> result = TelemetryConfigurationsCopier.copyToBuilder(this.telemetryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTelemetryConfigurations(Collection<TelemetryConfiguration.BuilderImpl> telemetryConfigurations) {
            this.telemetryConfigurations = TelemetryConfigurationsCopier.copyFromBuilder(telemetryConfigurations);
        }

        @Override
        public final Builder telemetryConfigurations(Collection<TelemetryConfiguration> telemetryConfigurations) {
            this.telemetryConfigurations = TelemetryConfigurationsCopier.copy(telemetryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryConfigurations(TelemetryConfiguration ... telemetryConfigurations) {
            this.telemetryConfigurations(Arrays.asList(telemetryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryConfigurations(Consumer<TelemetryConfiguration.Builder> ... telemetryConfigurations) {
            this.telemetryConfigurations(Stream.of(telemetryConfigurations).map(c -> (TelemetryConfiguration)((TelemetryConfiguration.Builder)TelemetryConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceTelemetryForOrganizationResponse build() {
            return new ListResourceTelemetryForOrganizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ObservabilityAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceTelemetryForOrganizationResponse> {
        public Builder telemetryConfigurations(Collection<TelemetryConfiguration> var1);

        public Builder telemetryConfigurations(TelemetryConfiguration ... var1);

        public Builder telemetryConfigurations(Consumer<TelemetryConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

