/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EncryptionStrategy {
    CUSTOMER_MANAGED("CUSTOMER_MANAGED"),
    AWS_OWNED("AWS_OWNED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EncryptionStrategy> VALUE_MAP;
    private final String value;

    private EncryptionStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionStrategy> knownValues() {
        EnumSet<EncryptionStrategy> knownValues = EnumSet.allOf(EncryptionStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EncryptionStrategy.class, EncryptionStrategy::toString);
    }
}

