/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfiguration;

public class ListResourceTelemetryForOrganizationIterable
implements SdkIterable<ListResourceTelemetryForOrganizationResponse> {
    private final ObservabilityAdminClient client;
    private final ListResourceTelemetryForOrganizationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceTelemetryForOrganizationIterable(ObservabilityAdminClient client, ListResourceTelemetryForOrganizationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceTelemetryForOrganizationResponseFetcher();
    }

    public Iterator<ListResourceTelemetryForOrganizationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TelemetryConfiguration> telemetryConfigurations() {
        Function<ListResourceTelemetryForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.telemetryConfigurations() != null) {
                return response.telemetryConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceTelemetryForOrganizationResponseFetcher
    implements SyncPageFetcher<ListResourceTelemetryForOrganizationResponse> {
        private ListResourceTelemetryForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceTelemetryForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceTelemetryForOrganizationResponse nextPage(ListResourceTelemetryForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return ListResourceTelemetryForOrganizationIterable.this.client.listResourceTelemetryForOrganization(ListResourceTelemetryForOrganizationIterable.this.firstRequest);
            }
            return ListResourceTelemetryForOrganizationIterable.this.client.listResourceTelemetryForOrganization((ListResourceTelemetryForOrganizationRequest)((Object)ListResourceTelemetryForOrganizationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

