/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.oam.OamAsyncClient;
import software.amazon.awssdk.services.oam.internal.UserAgentUtils;
import software.amazon.awssdk.services.oam.model.ListAttachedLinksItem;
import software.amazon.awssdk.services.oam.model.ListAttachedLinksRequest;
import software.amazon.awssdk.services.oam.model.ListAttachedLinksResponse;

public class ListAttachedLinksPublisher
implements SdkPublisher<ListAttachedLinksResponse> {
    private final OamAsyncClient client;
    private final ListAttachedLinksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttachedLinksPublisher(OamAsyncClient client, ListAttachedLinksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttachedLinksPublisher(OamAsyncClient client, ListAttachedLinksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttachedLinksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttachedLinksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListAttachedLinksItem> items() {
        Function<ListAttachedLinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAttachedLinksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAttachedLinksResponseFetcher
    implements AsyncPageFetcher<ListAttachedLinksResponse> {
        private ListAttachedLinksResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAttachedLinksResponse> nextPage(ListAttachedLinksResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedLinksPublisher.this.client.listAttachedLinks(ListAttachedLinksPublisher.this.firstRequest);
            }
            return ListAttachedLinksPublisher.this.client.listAttachedLinks((ListAttachedLinksRequest)((Object)ListAttachedLinksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

