/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.oam.OamClient;
import software.amazon.awssdk.services.oam.internal.UserAgentUtils;
import software.amazon.awssdk.services.oam.model.ListAttachedLinksItem;
import software.amazon.awssdk.services.oam.model.ListAttachedLinksRequest;
import software.amazon.awssdk.services.oam.model.ListAttachedLinksResponse;

public class ListAttachedLinksIterable
implements SdkIterable<ListAttachedLinksResponse> {
    private final OamClient client;
    private final ListAttachedLinksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttachedLinksIterable(OamClient client, ListAttachedLinksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAttachedLinksResponseFetcher();
    }

    public Iterator<ListAttachedLinksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListAttachedLinksItem> items() {
        Function<ListAttachedLinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAttachedLinksResponseFetcher
    implements SyncPageFetcher<ListAttachedLinksResponse> {
        private ListAttachedLinksResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAttachedLinksResponse nextPage(ListAttachedLinksResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedLinksIterable.this.client.listAttachedLinks(ListAttachedLinksIterable.this.firstRequest);
            }
            return ListAttachedLinksIterable.this.client.listAttachedLinks((ListAttachedLinksRequest)((Object)ListAttachedLinksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

