/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notificationscontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notificationscontacts.NotificationsContactsClient;
import software.amazon.awssdk.services.notificationscontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.notificationscontacts.model.EmailContact;
import software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest;
import software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsResponse;

public class ListEmailContactsIterable
implements SdkIterable<ListEmailContactsResponse> {
    private final NotificationsContactsClient client;
    private final ListEmailContactsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEmailContactsIterable(NotificationsContactsClient client, ListEmailContactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEmailContactsResponseFetcher();
    }

    public Iterator<ListEmailContactsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EmailContact> emailContacts() {
        Function<ListEmailContactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.emailContacts() != null) {
                return response.emailContacts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEmailContactsResponseFetcher
    implements SyncPageFetcher<ListEmailContactsResponse> {
        private ListEmailContactsResponseFetcher() {
        }

        public boolean hasNextPage(ListEmailContactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEmailContactsResponse nextPage(ListEmailContactsResponse previousPage) {
            if (previousPage == null) {
                return ListEmailContactsIterable.this.client.listEmailContacts(ListEmailContactsIterable.this.firstRequest);
            }
            return ListEmailContactsIterable.this.client.listEmailContacts((ListEmailContactsRequest)((Object)ListEmailContactsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

