/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsRequest;
import software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsResponse;

public class ListOrganizationalUnitsIterable
implements SdkIterable<ListOrganizationalUnitsResponse> {
    private final NotificationsClient client;
    private final ListOrganizationalUnitsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOrganizationalUnitsIterable(NotificationsClient client, ListOrganizationalUnitsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOrganizationalUnitsResponseFetcher();
    }

    public Iterator<ListOrganizationalUnitsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> organizationalUnits() {
        Function<ListOrganizationalUnitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.organizationalUnits() != null) {
                return response.organizationalUnits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOrganizationalUnitsResponseFetcher
    implements SyncPageFetcher<ListOrganizationalUnitsResponse> {
        private ListOrganizationalUnitsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationalUnitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOrganizationalUnitsResponse nextPage(ListOrganizationalUnitsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationalUnitsIterable.this.client.listOrganizationalUnits(ListOrganizationalUnitsIterable.this.firstRequest);
            }
            return ListOrganizationalUnitsIterable.this.client.listOrganizationalUnits((ListOrganizationalUnitsRequest)((Object)ListOrganizationalUnitsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

