/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.AggregatedNotificationRegionsCopier;
import software.amazon.awssdk.services.notifications.model.AggregationEventType;
import software.amazon.awssdk.services.notifications.model.AggregationSummary;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationEventSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedNotificationEventOverview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedNotificationEventOverview> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ManagedNotificationEventOverview.getter(ManagedNotificationEventOverview::arn)).setter(ManagedNotificationEventOverview.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedNotificationConfigurationArn").getter(ManagedNotificationEventOverview.getter(ManagedNotificationEventOverview::managedNotificationConfigurationArn)).setter(ManagedNotificationEventOverview.setter(Builder::managedNotificationConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedNotificationConfigurationArn").build()}).build();
    private static final SdkField<String> RELATED_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relatedAccount").getter(ManagedNotificationEventOverview.getter(ManagedNotificationEventOverview::relatedAccount)).setter(ManagedNotificationEventOverview.setter(Builder::relatedAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedAccount").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ManagedNotificationEventOverview.getter(ManagedNotificationEventOverview::creationTime)).setter(ManagedNotificationEventOverview.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ManagedNotificationEventSummary> NOTIFICATION_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("notificationEvent").getter(ManagedNotificationEventOverview.getter(ManagedNotificationEventOverview::notificationEvent)).setter(ManagedNotificationEventOverview.setter(Builder::notificationEvent)).constructor(ManagedNotificationEventSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationEvent").build()}).build();
    private static final SdkField<String> AGGREGATION_EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationEventType").getter(ManagedNotificationEventOverview.getter(ManagedNotificationEventOverview::aggregationEventTypeAsString)).setter(ManagedNotificationEventOverview.setter(Builder::aggregationEventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationEventType").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationalUnitId").getter(ManagedNotificationEventOverview.getter(ManagedNotificationEventOverview::organizationalUnitId)).setter(ManagedNotificationEventOverview.setter(Builder::organizationalUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitId").build()}).build();
    private static final SdkField<AggregationSummary> AGGREGATION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregationSummary").getter(ManagedNotificationEventOverview.getter(ManagedNotificationEventOverview::aggregationSummary)).setter(ManagedNotificationEventOverview.setter(Builder::aggregationSummary)).constructor(AggregationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationSummary").build()}).build();
    private static final SdkField<List<String>> AGGREGATED_NOTIFICATION_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aggregatedNotificationRegions").getter(ManagedNotificationEventOverview.getter(ManagedNotificationEventOverview::aggregatedNotificationRegions)).setter(ManagedNotificationEventOverview.setter(Builder::aggregatedNotificationRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedNotificationRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD, RELATED_ACCOUNT_FIELD, CREATION_TIME_FIELD, NOTIFICATION_EVENT_FIELD, AGGREGATION_EVENT_TYPE_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD, AGGREGATION_SUMMARY_FIELD, AGGREGATED_NOTIFICATION_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedNotificationEventOverview.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String managedNotificationConfigurationArn;
    private final String relatedAccount;
    private final Instant creationTime;
    private final ManagedNotificationEventSummary notificationEvent;
    private final String aggregationEventType;
    private final String organizationalUnitId;
    private final AggregationSummary aggregationSummary;
    private final List<String> aggregatedNotificationRegions;

    private ManagedNotificationEventOverview(BuilderImpl builder) {
        this.arn = builder.arn;
        this.managedNotificationConfigurationArn = builder.managedNotificationConfigurationArn;
        this.relatedAccount = builder.relatedAccount;
        this.creationTime = builder.creationTime;
        this.notificationEvent = builder.notificationEvent;
        this.aggregationEventType = builder.aggregationEventType;
        this.organizationalUnitId = builder.organizationalUnitId;
        this.aggregationSummary = builder.aggregationSummary;
        this.aggregatedNotificationRegions = builder.aggregatedNotificationRegions;
    }

    public final String arn() {
        return this.arn;
    }

    public final String managedNotificationConfigurationArn() {
        return this.managedNotificationConfigurationArn;
    }

    public final String relatedAccount() {
        return this.relatedAccount;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ManagedNotificationEventSummary notificationEvent() {
        return this.notificationEvent;
    }

    public final AggregationEventType aggregationEventType() {
        return AggregationEventType.fromValue(this.aggregationEventType);
    }

    public final String aggregationEventTypeAsString() {
        return this.aggregationEventType;
    }

    public final String organizationalUnitId() {
        return this.organizationalUnitId;
    }

    public final AggregationSummary aggregationSummary() {
        return this.aggregationSummary;
    }

    public final boolean hasAggregatedNotificationRegions() {
        return this.aggregatedNotificationRegions != null && !(this.aggregatedNotificationRegions instanceof SdkAutoConstructList);
    }

    public final List<String> aggregatedNotificationRegions() {
        return this.aggregatedNotificationRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedNotificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregatedNotificationRegions() ? this.aggregatedNotificationRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedNotificationEventOverview)) {
            return false;
        }
        ManagedNotificationEventOverview other = (ManagedNotificationEventOverview)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.managedNotificationConfigurationArn(), other.managedNotificationConfigurationArn()) && Objects.equals(this.relatedAccount(), other.relatedAccount()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.notificationEvent(), other.notificationEvent()) && Objects.equals(this.aggregationEventTypeAsString(), other.aggregationEventTypeAsString()) && Objects.equals(this.organizationalUnitId(), other.organizationalUnitId()) && Objects.equals(this.aggregationSummary(), other.aggregationSummary()) && this.hasAggregatedNotificationRegions() == other.hasAggregatedNotificationRegions() && Objects.equals(this.aggregatedNotificationRegions(), other.aggregatedNotificationRegions());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedNotificationEventOverview").add("Arn", (Object)this.arn()).add("ManagedNotificationConfigurationArn", (Object)this.managedNotificationConfigurationArn()).add("RelatedAccount", (Object)this.relatedAccount()).add("CreationTime", (Object)this.creationTime()).add("NotificationEvent", (Object)this.notificationEvent()).add("AggregationEventType", (Object)this.aggregationEventTypeAsString()).add("OrganizationalUnitId", (Object)this.organizationalUnitId()).add("AggregationSummary", (Object)this.aggregationSummary()).add("AggregatedNotificationRegions", this.hasAggregatedNotificationRegions() ? this.aggregatedNotificationRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "managedNotificationConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.managedNotificationConfigurationArn()));
            }
            case "relatedAccount": {
                return Optional.ofNullable(clazz.cast(this.relatedAccount()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "notificationEvent": {
                return Optional.ofNullable(clazz.cast(this.notificationEvent()));
            }
            case "aggregationEventType": {
                return Optional.ofNullable(clazz.cast(this.aggregationEventTypeAsString()));
            }
            case "organizationalUnitId": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitId()));
            }
            case "aggregationSummary": {
                return Optional.ofNullable(clazz.cast(this.aggregationSummary()));
            }
            case "aggregatedNotificationRegions": {
                return Optional.ofNullable(clazz.cast(this.aggregatedNotificationRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("managedNotificationConfigurationArn", MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("relatedAccount", RELATED_ACCOUNT_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("notificationEvent", NOTIFICATION_EVENT_FIELD);
        map.put("aggregationEventType", AGGREGATION_EVENT_TYPE_FIELD);
        map.put("organizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        map.put("aggregationSummary", AGGREGATION_SUMMARY_FIELD);
        map.put("aggregatedNotificationRegions", AGGREGATED_NOTIFICATION_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedNotificationEventOverview, T> g) {
        return obj -> g.apply((ManagedNotificationEventOverview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String managedNotificationConfigurationArn;
        private String relatedAccount;
        private Instant creationTime;
        private ManagedNotificationEventSummary notificationEvent;
        private String aggregationEventType;
        private String organizationalUnitId;
        private AggregationSummary aggregationSummary;
        private List<String> aggregatedNotificationRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedNotificationEventOverview model) {
            this.arn(model.arn);
            this.managedNotificationConfigurationArn(model.managedNotificationConfigurationArn);
            this.relatedAccount(model.relatedAccount);
            this.creationTime(model.creationTime);
            this.notificationEvent(model.notificationEvent);
            this.aggregationEventType(model.aggregationEventType);
            this.organizationalUnitId(model.organizationalUnitId);
            this.aggregationSummary(model.aggregationSummary);
            this.aggregatedNotificationRegions(model.aggregatedNotificationRegions);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getManagedNotificationConfigurationArn() {
            return this.managedNotificationConfigurationArn;
        }

        public final void setManagedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
        }

        @Override
        public final Builder managedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
            return this;
        }

        public final String getRelatedAccount() {
            return this.relatedAccount;
        }

        public final void setRelatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
        }

        @Override
        public final Builder relatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ManagedNotificationEventSummary.Builder getNotificationEvent() {
            return this.notificationEvent != null ? this.notificationEvent.toBuilder() : null;
        }

        public final void setNotificationEvent(ManagedNotificationEventSummary.BuilderImpl notificationEvent) {
            this.notificationEvent = notificationEvent != null ? notificationEvent.build() : null;
        }

        @Override
        public final Builder notificationEvent(ManagedNotificationEventSummary notificationEvent) {
            this.notificationEvent = notificationEvent;
            return this;
        }

        public final String getAggregationEventType() {
            return this.aggregationEventType;
        }

        public final void setAggregationEventType(String aggregationEventType) {
            this.aggregationEventType = aggregationEventType;
        }

        @Override
        public final Builder aggregationEventType(String aggregationEventType) {
            this.aggregationEventType = aggregationEventType;
            return this;
        }

        @Override
        public final Builder aggregationEventType(AggregationEventType aggregationEventType) {
            this.aggregationEventType(aggregationEventType == null ? null : aggregationEventType.toString());
            return this;
        }

        public final String getOrganizationalUnitId() {
            return this.organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public final AggregationSummary.Builder getAggregationSummary() {
            return this.aggregationSummary != null ? this.aggregationSummary.toBuilder() : null;
        }

        public final void setAggregationSummary(AggregationSummary.BuilderImpl aggregationSummary) {
            this.aggregationSummary = aggregationSummary != null ? aggregationSummary.build() : null;
        }

        @Override
        public final Builder aggregationSummary(AggregationSummary aggregationSummary) {
            this.aggregationSummary = aggregationSummary;
            return this;
        }

        public final Collection<String> getAggregatedNotificationRegions() {
            if (this.aggregatedNotificationRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aggregatedNotificationRegions;
        }

        public final void setAggregatedNotificationRegions(Collection<String> aggregatedNotificationRegions) {
            this.aggregatedNotificationRegions = AggregatedNotificationRegionsCopier.copy(aggregatedNotificationRegions);
        }

        @Override
        public final Builder aggregatedNotificationRegions(Collection<String> aggregatedNotificationRegions) {
            this.aggregatedNotificationRegions = AggregatedNotificationRegionsCopier.copy(aggregatedNotificationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedNotificationRegions(String ... aggregatedNotificationRegions) {
            this.aggregatedNotificationRegions(Arrays.asList(aggregatedNotificationRegions));
            return this;
        }

        public ManagedNotificationEventOverview build() {
            return new ManagedNotificationEventOverview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedNotificationEventOverview> {
        public Builder arn(String var1);

        public Builder managedNotificationConfigurationArn(String var1);

        public Builder relatedAccount(String var1);

        public Builder creationTime(Instant var1);

        public Builder notificationEvent(ManagedNotificationEventSummary var1);

        default public Builder notificationEvent(Consumer<ManagedNotificationEventSummary.Builder> notificationEvent) {
            return this.notificationEvent((ManagedNotificationEventSummary)((ManagedNotificationEventSummary.Builder)ManagedNotificationEventSummary.builder().applyMutation(notificationEvent)).build());
        }

        public Builder aggregationEventType(String var1);

        public Builder aggregationEventType(AggregationEventType var1);

        public Builder organizationalUnitId(String var1);

        public Builder aggregationSummary(AggregationSummary var1);

        default public Builder aggregationSummary(Consumer<AggregationSummary.Builder> aggregationSummary) {
            return this.aggregationSummary((AggregationSummary)((AggregationSummary.Builder)AggregationSummary.builder().applyMutation(aggregationSummary)).build());
        }

        public Builder aggregatedNotificationRegions(Collection<String> var1);

        public Builder aggregatedNotificationRegions(String ... var1);
    }
}

