/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotificationConfigurationSubtype {
    ACCOUNT("ACCOUNT"),
    ADMIN_MANAGED("ADMIN_MANAGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotificationConfigurationSubtype> VALUE_MAP;
    private final String value;

    private NotificationConfigurationSubtype(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationConfigurationSubtype fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationConfigurationSubtype> knownValues() {
        EnumSet<NotificationConfigurationSubtype> knownValues = EnumSet.allOf(NotificationConfigurationSubtype.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotificationConfigurationSubtype.class, NotificationConfigurationSubtype::toString);
    }
}

