/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest;
import software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsResponse;
import software.amazon.awssdk.services.notifications.model.NotificationConfigurationStructure;

public class ListNotificationConfigurationsIterable
implements SdkIterable<ListNotificationConfigurationsResponse> {
    private final NotificationsClient client;
    private final ListNotificationConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNotificationConfigurationsIterable(NotificationsClient client, ListNotificationConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNotificationConfigurationsResponseFetcher();
    }

    public Iterator<ListNotificationConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NotificationConfigurationStructure> notificationConfigurations() {
        Function<ListNotificationConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notificationConfigurations() != null) {
                return response.notificationConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNotificationConfigurationsResponseFetcher
    implements SyncPageFetcher<ListNotificationConfigurationsResponse> {
        private ListNotificationConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNotificationConfigurationsResponse nextPage(ListNotificationConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationConfigurationsIterable.this.client.listNotificationConfigurations(ListNotificationConfigurationsIterable.this.firstRequest);
            }
            return ListNotificationConfigurationsIterable.this.client.listNotificationConfigurations((ListNotificationConfigurationsRequest)((Object)ListNotificationConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

