/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsResponse;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationConfigurationStructure;

public class ListManagedNotificationConfigurationsIterable
implements SdkIterable<ListManagedNotificationConfigurationsResponse> {
    private final NotificationsClient client;
    private final ListManagedNotificationConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedNotificationConfigurationsIterable(NotificationsClient client, ListManagedNotificationConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedNotificationConfigurationsResponseFetcher();
    }

    public Iterator<ListManagedNotificationConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedNotificationConfigurationStructure> managedNotificationConfigurations() {
        Function<ListManagedNotificationConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedNotificationConfigurations() != null) {
                return response.managedNotificationConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedNotificationConfigurationsResponseFetcher
    implements SyncPageFetcher<ListManagedNotificationConfigurationsResponse> {
        private ListManagedNotificationConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedNotificationConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedNotificationConfigurationsResponse nextPage(ListManagedNotificationConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedNotificationConfigurationsIterable.this.client.listManagedNotificationConfigurations(ListManagedNotificationConfigurationsIterable.this.firstRequest);
            }
            return ListManagedNotificationConfigurationsIterable.this.client.listManagedNotificationConfigurations((ListManagedNotificationConfigurationsRequest)((Object)ListManagedNotificationConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

