/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsAsyncClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsResponse;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationChildEventOverview;

public class ListManagedNotificationChildEventsPublisher
implements SdkPublisher<ListManagedNotificationChildEventsResponse> {
    private final NotificationsAsyncClient client;
    private final ListManagedNotificationChildEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedNotificationChildEventsPublisher(NotificationsAsyncClient client, ListManagedNotificationChildEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedNotificationChildEventsPublisher(NotificationsAsyncClient client, ListManagedNotificationChildEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedNotificationChildEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedNotificationChildEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedNotificationChildEventOverview> managedNotificationChildEvents() {
        Function<ListManagedNotificationChildEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedNotificationChildEvents() != null) {
                return response.managedNotificationChildEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedNotificationChildEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedNotificationChildEventsResponseFetcher
    implements AsyncPageFetcher<ListManagedNotificationChildEventsResponse> {
        private ListManagedNotificationChildEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedNotificationChildEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedNotificationChildEventsResponse> nextPage(ListManagedNotificationChildEventsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedNotificationChildEventsPublisher.this.client.listManagedNotificationChildEvents(ListManagedNotificationChildEventsPublisher.this.firstRequest);
            }
            return ListManagedNotificationChildEventsPublisher.this.client.listManagedNotificationChildEvents((ListManagedNotificationChildEventsRequest)((Object)ListManagedNotificationChildEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

