/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.notifications.model.NotificationHubStatusSummary;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterNotificationHubResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, RegisterNotificationHubResponse> {
    private static final SdkField<String> NOTIFICATION_HUB_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("notificationHubRegion").getter(RegisterNotificationHubResponse.getter(RegisterNotificationHubResponse::notificationHubRegion)).setter(RegisterNotificationHubResponse.setter(Builder::notificationHubRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationHubRegion").build()}).build();
    private static final SdkField<NotificationHubStatusSummary> STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusSummary").getter(RegisterNotificationHubResponse.getter(RegisterNotificationHubResponse::statusSummary)).setter(RegisterNotificationHubResponse.setter(Builder::statusSummary)).constructor(NotificationHubStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(RegisterNotificationHubResponse.getter(RegisterNotificationHubResponse::creationTime)).setter(RegisterNotificationHubResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_ACTIVATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastActivationTime").getter(RegisterNotificationHubResponse.getter(RegisterNotificationHubResponse::lastActivationTime)).setter(RegisterNotificationHubResponse.setter(Builder::lastActivationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastActivationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_HUB_REGION_FIELD, STATUS_SUMMARY_FIELD, CREATION_TIME_FIELD, LAST_ACTIVATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisterNotificationHubResponse.memberNameToFieldInitializer();
    private final String notificationHubRegion;
    private final NotificationHubStatusSummary statusSummary;
    private final Instant creationTime;
    private final Instant lastActivationTime;

    private RegisterNotificationHubResponse(BuilderImpl builder) {
        super(builder);
        this.notificationHubRegion = builder.notificationHubRegion;
        this.statusSummary = builder.statusSummary;
        this.creationTime = builder.creationTime;
        this.lastActivationTime = builder.lastActivationTime;
    }

    public final String notificationHubRegion() {
        return this.notificationHubRegion;
    }

    public final NotificationHubStatusSummary statusSummary() {
        return this.statusSummary;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastActivationTime() {
        return this.lastActivationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationHubRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastActivationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterNotificationHubResponse)) {
            return false;
        }
        RegisterNotificationHubResponse other = (RegisterNotificationHubResponse)((Object)obj);
        return Objects.equals(this.notificationHubRegion(), other.notificationHubRegion()) && Objects.equals(this.statusSummary(), other.statusSummary()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastActivationTime(), other.lastActivationTime());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterNotificationHubResponse").add("NotificationHubRegion", (Object)this.notificationHubRegion()).add("StatusSummary", (Object)this.statusSummary()).add("CreationTime", (Object)this.creationTime()).add("LastActivationTime", (Object)this.lastActivationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "notificationHubRegion": {
                return Optional.ofNullable(clazz.cast(this.notificationHubRegion()));
            }
            case "statusSummary": {
                return Optional.ofNullable(clazz.cast(this.statusSummary()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastActivationTime": {
                return Optional.ofNullable(clazz.cast(this.lastActivationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("notificationHubRegion", NOTIFICATION_HUB_REGION_FIELD);
        map.put("statusSummary", STATUS_SUMMARY_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastActivationTime", LAST_ACTIVATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterNotificationHubResponse, T> g) {
        return obj -> g.apply((RegisterNotificationHubResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private String notificationHubRegion;
        private NotificationHubStatusSummary statusSummary;
        private Instant creationTime;
        private Instant lastActivationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterNotificationHubResponse model) {
            super(model);
            this.notificationHubRegion(model.notificationHubRegion);
            this.statusSummary(model.statusSummary);
            this.creationTime(model.creationTime);
            this.lastActivationTime(model.lastActivationTime);
        }

        public final String getNotificationHubRegion() {
            return this.notificationHubRegion;
        }

        public final void setNotificationHubRegion(String notificationHubRegion) {
            this.notificationHubRegion = notificationHubRegion;
        }

        @Override
        public final Builder notificationHubRegion(String notificationHubRegion) {
            this.notificationHubRegion = notificationHubRegion;
            return this;
        }

        public final NotificationHubStatusSummary.Builder getStatusSummary() {
            return this.statusSummary != null ? this.statusSummary.toBuilder() : null;
        }

        public final void setStatusSummary(NotificationHubStatusSummary.BuilderImpl statusSummary) {
            this.statusSummary = statusSummary != null ? statusSummary.build() : null;
        }

        @Override
        public final Builder statusSummary(NotificationHubStatusSummary statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastActivationTime() {
            return this.lastActivationTime;
        }

        public final void setLastActivationTime(Instant lastActivationTime) {
            this.lastActivationTime = lastActivationTime;
        }

        @Override
        public final Builder lastActivationTime(Instant lastActivationTime) {
            this.lastActivationTime = lastActivationTime;
            return this;
        }

        @Override
        public RegisterNotificationHubResponse build() {
            return new RegisterNotificationHubResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterNotificationHubResponse> {
        public Builder notificationHubRegion(String var1);

        public Builder statusSummary(NotificationHubStatusSummary var1);

        default public Builder statusSummary(Consumer<NotificationHubStatusSummary.Builder> statusSummary) {
            return this.statusSummary((NotificationHubStatusSummary)((NotificationHubStatusSummary.Builder)NotificationHubStatusSummary.builder().applyMutation(statusSummary)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastActivationTime(Instant var1);
    }
}

