/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotificationHubStatus {
    ACTIVE("ACTIVE"),
    REGISTERING("REGISTERING"),
    DEREGISTERING("DEREGISTERING"),
    INACTIVE("INACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotificationHubStatus> VALUE_MAP;
    private final String value;

    private NotificationHubStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationHubStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationHubStatus> knownValues() {
        EnumSet<NotificationHubStatus> knownValues = EnumSet.allOf(NotificationHubStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotificationHubStatus.class, NotificationHubStatus::toString);
    }
}

