/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.AccountStatus;
import software.amazon.awssdk.services.networkmanager.model.AccountStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationStatus> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(OrganizationStatus.getter(OrganizationStatus::organizationId)).setter(OrganizationStatus.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> ORGANIZATION_AWS_SERVICE_ACCESS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationAwsServiceAccessStatus").getter(OrganizationStatus.getter(OrganizationStatus::organizationAwsServiceAccessStatus)).setter(OrganizationStatus.setter(Builder::organizationAwsServiceAccessStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationAwsServiceAccessStatus").build()}).build();
    private static final SdkField<String> SLR_DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SLRDeploymentStatus").getter(OrganizationStatus.getter(OrganizationStatus::slrDeploymentStatus)).setter(OrganizationStatus.setter(Builder::slrDeploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SLRDeploymentStatus").build()}).build();
    private static final SdkField<List<AccountStatus>> ACCOUNT_STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountStatusList").getter(OrganizationStatus.getter(OrganizationStatus::accountStatusList)).setter(OrganizationStatus.setter(Builder::accountStatusList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountStatusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, ORGANIZATION_AWS_SERVICE_ACCESS_STATUS_FIELD, SLR_DEPLOYMENT_STATUS_FIELD, ACCOUNT_STATUS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrganizationStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String organizationId;
    private final String organizationAwsServiceAccessStatus;
    private final String slrDeploymentStatus;
    private final List<AccountStatus> accountStatusList;

    private OrganizationStatus(BuilderImpl builder) {
        this.organizationId = builder.organizationId;
        this.organizationAwsServiceAccessStatus = builder.organizationAwsServiceAccessStatus;
        this.slrDeploymentStatus = builder.slrDeploymentStatus;
        this.accountStatusList = builder.accountStatusList;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String organizationAwsServiceAccessStatus() {
        return this.organizationAwsServiceAccessStatus;
    }

    public final String slrDeploymentStatus() {
        return this.slrDeploymentStatus;
    }

    public final boolean hasAccountStatusList() {
        return this.accountStatusList != null && !(this.accountStatusList instanceof SdkAutoConstructList);
    }

    public final List<AccountStatus> accountStatusList() {
        return this.accountStatusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationAwsServiceAccessStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.slrDeploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountStatusList() ? this.accountStatusList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationStatus)) {
            return false;
        }
        OrganizationStatus other = (OrganizationStatus)obj;
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.organizationAwsServiceAccessStatus(), other.organizationAwsServiceAccessStatus()) && Objects.equals(this.slrDeploymentStatus(), other.slrDeploymentStatus()) && this.hasAccountStatusList() == other.hasAccountStatusList() && Objects.equals(this.accountStatusList(), other.accountStatusList());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationStatus").add("OrganizationId", (Object)this.organizationId()).add("OrganizationAwsServiceAccessStatus", (Object)this.organizationAwsServiceAccessStatus()).add("SLRDeploymentStatus", (Object)this.slrDeploymentStatus()).add("AccountStatusList", this.hasAccountStatusList() ? this.accountStatusList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "OrganizationAwsServiceAccessStatus": {
                return Optional.ofNullable(clazz.cast(this.organizationAwsServiceAccessStatus()));
            }
            case "SLRDeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.slrDeploymentStatus()));
            }
            case "AccountStatusList": {
                return Optional.ofNullable(clazz.cast(this.accountStatusList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("OrganizationAwsServiceAccessStatus", ORGANIZATION_AWS_SERVICE_ACCESS_STATUS_FIELD);
        map.put("SLRDeploymentStatus", SLR_DEPLOYMENT_STATUS_FIELD);
        map.put("AccountStatusList", ACCOUNT_STATUS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationStatus, T> g) {
        return obj -> g.apply((OrganizationStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String organizationId;
        private String organizationAwsServiceAccessStatus;
        private String slrDeploymentStatus;
        private List<AccountStatus> accountStatusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationStatus model) {
            this.organizationId(model.organizationId);
            this.organizationAwsServiceAccessStatus(model.organizationAwsServiceAccessStatus);
            this.slrDeploymentStatus(model.slrDeploymentStatus);
            this.accountStatusList(model.accountStatusList);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getOrganizationAwsServiceAccessStatus() {
            return this.organizationAwsServiceAccessStatus;
        }

        public final void setOrganizationAwsServiceAccessStatus(String organizationAwsServiceAccessStatus) {
            this.organizationAwsServiceAccessStatus = organizationAwsServiceAccessStatus;
        }

        @Override
        public final Builder organizationAwsServiceAccessStatus(String organizationAwsServiceAccessStatus) {
            this.organizationAwsServiceAccessStatus = organizationAwsServiceAccessStatus;
            return this;
        }

        public final String getSlrDeploymentStatus() {
            return this.slrDeploymentStatus;
        }

        public final void setSlrDeploymentStatus(String slrDeploymentStatus) {
            this.slrDeploymentStatus = slrDeploymentStatus;
        }

        @Override
        public final Builder slrDeploymentStatus(String slrDeploymentStatus) {
            this.slrDeploymentStatus = slrDeploymentStatus;
            return this;
        }

        public final List<AccountStatus.Builder> getAccountStatusList() {
            List<AccountStatus.Builder> result = AccountStatusListCopier.copyToBuilder(this.accountStatusList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountStatusList(Collection<AccountStatus.BuilderImpl> accountStatusList) {
            this.accountStatusList = AccountStatusListCopier.copyFromBuilder(accountStatusList);
        }

        @Override
        public final Builder accountStatusList(Collection<AccountStatus> accountStatusList) {
            this.accountStatusList = AccountStatusListCopier.copy(accountStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountStatusList(AccountStatus ... accountStatusList) {
            this.accountStatusList(Arrays.asList(accountStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountStatusList(Consumer<AccountStatus.Builder> ... accountStatusList) {
            this.accountStatusList(Stream.of(accountStatusList).map(c -> (AccountStatus)((AccountStatus.Builder)AccountStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OrganizationStatus build() {
            return new OrganizationStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationStatus> {
        public Builder organizationId(String var1);

        public Builder organizationAwsServiceAccessStatus(String var1);

        public Builder slrDeploymentStatus(String var1);

        public Builder accountStatusList(Collection<AccountStatus> var1);

        public Builder accountStatusList(AccountStatus ... var1);

        public Builder accountStatusList(Consumer<AccountStatus.Builder> ... var1);
    }
}

