/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ConstrainedStringListCopier;
import software.amazon.awssdk.services.networkmanager.model.RoutingInformationNextHop;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoreNetworkRoutingInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoreNetworkRoutingInformation> {
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(CoreNetworkRoutingInformation.getter(CoreNetworkRoutingInformation::prefix)).setter(CoreNetworkRoutingInformation.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final SdkField<RoutingInformationNextHop> NEXT_HOP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NextHop").getter(CoreNetworkRoutingInformation.getter(CoreNetworkRoutingInformation::nextHop)).setter(CoreNetworkRoutingInformation.setter(Builder::nextHop)).constructor(RoutingInformationNextHop::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextHop").build()}).build();
    private static final SdkField<String> LOCAL_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalPreference").getter(CoreNetworkRoutingInformation.getter(CoreNetworkRoutingInformation::localPreference)).setter(CoreNetworkRoutingInformation.setter(Builder::localPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPreference").build()}).build();
    private static final SdkField<String> MED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Med").getter(CoreNetworkRoutingInformation.getter(CoreNetworkRoutingInformation::med)).setter(CoreNetworkRoutingInformation.setter(Builder::med)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Med").build()}).build();
    private static final SdkField<List<String>> AS_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AsPath").getter(CoreNetworkRoutingInformation.getter(CoreNetworkRoutingInformation::asPath)).setter(CoreNetworkRoutingInformation.setter(Builder::asPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMMUNITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Communities").getter(CoreNetworkRoutingInformation.getter(CoreNetworkRoutingInformation::communities)).setter(CoreNetworkRoutingInformation.setter(Builder::communities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Communities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD, NEXT_HOP_FIELD, LOCAL_PREFERENCE_FIELD, MED_FIELD, AS_PATH_FIELD, COMMUNITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CoreNetworkRoutingInformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String prefix;
    private final RoutingInformationNextHop nextHop;
    private final String localPreference;
    private final String med;
    private final List<String> asPath;
    private final List<String> communities;

    private CoreNetworkRoutingInformation(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.nextHop = builder.nextHop;
        this.localPreference = builder.localPreference;
        this.med = builder.med;
        this.asPath = builder.asPath;
        this.communities = builder.communities;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final RoutingInformationNextHop nextHop() {
        return this.nextHop;
    }

    public final String localPreference() {
        return this.localPreference;
    }

    public final String med() {
        return this.med;
    }

    public final boolean hasAsPath() {
        return this.asPath != null && !(this.asPath instanceof SdkAutoConstructList);
    }

    public final List<String> asPath() {
        return this.asPath;
    }

    public final boolean hasCommunities() {
        return this.communities != null && !(this.communities instanceof SdkAutoConstructList);
    }

    public final List<String> communities() {
        return this.communities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextHop());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.med());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAsPath() ? this.asPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommunities() ? this.communities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkRoutingInformation)) {
            return false;
        }
        CoreNetworkRoutingInformation other = (CoreNetworkRoutingInformation)obj;
        return Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.nextHop(), other.nextHop()) && Objects.equals(this.localPreference(), other.localPreference()) && Objects.equals(this.med(), other.med()) && this.hasAsPath() == other.hasAsPath() && Objects.equals(this.asPath(), other.asPath()) && this.hasCommunities() == other.hasCommunities() && Objects.equals(this.communities(), other.communities());
    }

    public final String toString() {
        return ToString.builder((String)"CoreNetworkRoutingInformation").add("Prefix", (Object)this.prefix()).add("NextHop", (Object)this.nextHop()).add("LocalPreference", (Object)this.localPreference()).add("Med", (Object)this.med()).add("AsPath", this.hasAsPath() ? this.asPath() : null).add("Communities", this.hasCommunities() ? this.communities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "NextHop": {
                return Optional.ofNullable(clazz.cast(this.nextHop()));
            }
            case "LocalPreference": {
                return Optional.ofNullable(clazz.cast(this.localPreference()));
            }
            case "Med": {
                return Optional.ofNullable(clazz.cast(this.med()));
            }
            case "AsPath": {
                return Optional.ofNullable(clazz.cast(this.asPath()));
            }
            case "Communities": {
                return Optional.ofNullable(clazz.cast(this.communities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Prefix", PREFIX_FIELD);
        map.put("NextHop", NEXT_HOP_FIELD);
        map.put("LocalPreference", LOCAL_PREFERENCE_FIELD);
        map.put("Med", MED_FIELD);
        map.put("AsPath", AS_PATH_FIELD);
        map.put("Communities", COMMUNITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkRoutingInformation, T> g) {
        return obj -> g.apply((CoreNetworkRoutingInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String prefix;
        private RoutingInformationNextHop nextHop;
        private String localPreference;
        private String med;
        private List<String> asPath = DefaultSdkAutoConstructList.getInstance();
        private List<String> communities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkRoutingInformation model) {
            this.prefix(model.prefix);
            this.nextHop(model.nextHop);
            this.localPreference(model.localPreference);
            this.med(model.med);
            this.asPath(model.asPath);
            this.communities(model.communities);
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final RoutingInformationNextHop.Builder getNextHop() {
            return this.nextHop != null ? this.nextHop.toBuilder() : null;
        }

        public final void setNextHop(RoutingInformationNextHop.BuilderImpl nextHop) {
            this.nextHop = nextHop != null ? nextHop.build() : null;
        }

        @Override
        public final Builder nextHop(RoutingInformationNextHop nextHop) {
            this.nextHop = nextHop;
            return this;
        }

        public final String getLocalPreference() {
            return this.localPreference;
        }

        public final void setLocalPreference(String localPreference) {
            this.localPreference = localPreference;
        }

        @Override
        public final Builder localPreference(String localPreference) {
            this.localPreference = localPreference;
            return this;
        }

        public final String getMed() {
            return this.med;
        }

        public final void setMed(String med) {
            this.med = med;
        }

        @Override
        public final Builder med(String med) {
            this.med = med;
            return this;
        }

        public final Collection<String> getAsPath() {
            if (this.asPath instanceof SdkAutoConstructList) {
                return null;
            }
            return this.asPath;
        }

        public final void setAsPath(Collection<String> asPath) {
            this.asPath = ConstrainedStringListCopier.copy(asPath);
        }

        @Override
        public final Builder asPath(Collection<String> asPath) {
            this.asPath = ConstrainedStringListCopier.copy(asPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asPath(String ... asPath) {
            this.asPath(Arrays.asList(asPath));
            return this;
        }

        public final Collection<String> getCommunities() {
            if (this.communities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.communities;
        }

        public final void setCommunities(Collection<String> communities) {
            this.communities = ConstrainedStringListCopier.copy(communities);
        }

        @Override
        public final Builder communities(Collection<String> communities) {
            this.communities = ConstrainedStringListCopier.copy(communities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communities(String ... communities) {
            this.communities(Arrays.asList(communities));
            return this;
        }

        public CoreNetworkRoutingInformation build() {
            return new CoreNetworkRoutingInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoreNetworkRoutingInformation> {
        public Builder prefix(String var1);

        public Builder nextHop(RoutingInformationNextHop var1);

        default public Builder nextHop(Consumer<RoutingInformationNextHop.Builder> nextHop) {
            return this.nextHop((RoutingInformationNextHop)((RoutingInformationNextHop.Builder)RoutingInformationNextHop.builder().applyMutation(nextHop)).build());
        }

        public Builder localPreference(String var1);

        public Builder med(String var1);

        public Builder asPath(Collection<String> var1);

        public Builder asPath(String ... var1);

        public Builder communities(Collection<String> var1);

        public Builder communities(String ... var1);
    }
}

