/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteAnalysisEndpointOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteAnalysisEndpointOptions> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentArn").getter(RouteAnalysisEndpointOptions.getter(RouteAnalysisEndpointOptions::transitGatewayAttachmentArn)).setter(RouteAnalysisEndpointOptions.setter(Builder::transitGatewayAttachmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentArn").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayArn").getter(RouteAnalysisEndpointOptions.getter(RouteAnalysisEndpointOptions::transitGatewayArn)).setter(RouteAnalysisEndpointOptions.setter(Builder::transitGatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayArn").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(RouteAnalysisEndpointOptions.getter(RouteAnalysisEndpointOptions::ipAddress)).setter(RouteAnalysisEndpointOptions.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ATTACHMENT_ARN_FIELD, TRANSIT_GATEWAY_ARN_FIELD, IP_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteAnalysisEndpointOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transitGatewayAttachmentArn;
    private final String transitGatewayArn;
    private final String ipAddress;

    private RouteAnalysisEndpointOptions(BuilderImpl builder) {
        this.transitGatewayAttachmentArn = builder.transitGatewayAttachmentArn;
        this.transitGatewayArn = builder.transitGatewayArn;
        this.ipAddress = builder.ipAddress;
    }

    public final String transitGatewayAttachmentArn() {
        return this.transitGatewayAttachmentArn;
    }

    public final String transitGatewayArn() {
        return this.transitGatewayArn;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAnalysisEndpointOptions)) {
            return false;
        }
        RouteAnalysisEndpointOptions other = (RouteAnalysisEndpointOptions)obj;
        return Objects.equals(this.transitGatewayAttachmentArn(), other.transitGatewayAttachmentArn()) && Objects.equals(this.transitGatewayArn(), other.transitGatewayArn()) && Objects.equals(this.ipAddress(), other.ipAddress());
    }

    public final String toString() {
        return ToString.builder((String)"RouteAnalysisEndpointOptions").add("TransitGatewayAttachmentArn", (Object)this.transitGatewayAttachmentArn()).add("TransitGatewayArn", (Object)this.transitGatewayArn()).add("IpAddress", (Object)this.ipAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAttachmentArn": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentArn()));
            }
            case "TransitGatewayArn": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayArn()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TransitGatewayAttachmentArn", TRANSIT_GATEWAY_ATTACHMENT_ARN_FIELD);
        map.put("TransitGatewayArn", TRANSIT_GATEWAY_ARN_FIELD);
        map.put("IpAddress", IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteAnalysisEndpointOptions, T> g) {
        return obj -> g.apply((RouteAnalysisEndpointOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayAttachmentArn;
        private String transitGatewayArn;
        private String ipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteAnalysisEndpointOptions model) {
            this.transitGatewayAttachmentArn(model.transitGatewayAttachmentArn);
            this.transitGatewayArn(model.transitGatewayArn);
            this.ipAddress(model.ipAddress);
        }

        public final String getTransitGatewayAttachmentArn() {
            return this.transitGatewayAttachmentArn;
        }

        public final void setTransitGatewayAttachmentArn(String transitGatewayAttachmentArn) {
            this.transitGatewayAttachmentArn = transitGatewayAttachmentArn;
        }

        @Override
        public final Builder transitGatewayAttachmentArn(String transitGatewayAttachmentArn) {
            this.transitGatewayAttachmentArn = transitGatewayAttachmentArn;
            return this;
        }

        public final String getTransitGatewayArn() {
            return this.transitGatewayArn;
        }

        public final void setTransitGatewayArn(String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
        }

        @Override
        public final Builder transitGatewayArn(String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public RouteAnalysisEndpointOptions build() {
            return new RouteAnalysisEndpointOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteAnalysisEndpointOptions> {
        public Builder transitGatewayAttachmentArn(String var1);

        public Builder transitGatewayArn(String var1);

        public Builder ipAddress(String var1);
    }
}

