/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.services.networkmanager.model.SubnetArnListCopier;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.services.networkmanager.model.VpcOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcAttachmentRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, CreateVpcAttachmentRequest> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(CreateVpcAttachmentRequest.getter(CreateVpcAttachmentRequest::coreNetworkId)).setter(CreateVpcAttachmentRequest.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()}).build();
    private static final SdkField<String> VPC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcArn").getter(CreateVpcAttachmentRequest.getter(CreateVpcAttachmentRequest::vpcArn)).setter(CreateVpcAttachmentRequest.setter(Builder::vpcArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcArn").build()}).build();
    private static final SdkField<List<String>> SUBNET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetArns").getter(CreateVpcAttachmentRequest.getter(CreateVpcAttachmentRequest::subnetArns)).setter(CreateVpcAttachmentRequest.setter(Builder::subnetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(CreateVpcAttachmentRequest.getter(CreateVpcAttachmentRequest::options)).setter(CreateVpcAttachmentRequest.setter(Builder::options)).constructor(VpcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateVpcAttachmentRequest.getter(CreateVpcAttachmentRequest::tags)).setter(CreateVpcAttachmentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateVpcAttachmentRequest.getter(CreateVpcAttachmentRequest::clientToken)).setter(CreateVpcAttachmentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD, VPC_ARN_FIELD, SUBNET_ARNS_FIELD, OPTIONS_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVpcAttachmentRequest.memberNameToFieldInitializer();
    private final String coreNetworkId;
    private final String vpcArn;
    private final List<String> subnetArns;
    private final VpcOptions options;
    private final List<Tag> tags;
    private final String clientToken;

    private CreateVpcAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.coreNetworkId = builder.coreNetworkId;
        this.vpcArn = builder.vpcArn;
        this.subnetArns = builder.subnetArns;
        this.options = builder.options;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String vpcArn() {
        return this.vpcArn;
    }

    public final boolean hasSubnetArns() {
        return this.subnetArns != null && !(this.subnetArns instanceof SdkAutoConstructList);
    }

    public final List<String> subnetArns() {
        return this.subnetArns;
    }

    public final VpcOptions options() {
        return this.options;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetArns() ? this.subnetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcAttachmentRequest)) {
            return false;
        }
        CreateVpcAttachmentRequest other = (CreateVpcAttachmentRequest)((Object)obj);
        return Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.vpcArn(), other.vpcArn()) && this.hasSubnetArns() == other.hasSubnetArns() && Objects.equals(this.subnetArns(), other.subnetArns()) && Objects.equals(this.options(), other.options()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcAttachmentRequest").add("CoreNetworkId", (Object)this.coreNetworkId()).add("VpcArn", (Object)this.vpcArn()).add("SubnetArns", this.hasSubnetArns() ? this.subnetArns() : null).add("Options", (Object)this.options()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "VpcArn": {
                return Optional.ofNullable(clazz.cast(this.vpcArn()));
            }
            case "SubnetArns": {
                return Optional.ofNullable(clazz.cast(this.subnetArns()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("VpcArn", VPC_ARN_FIELD);
        map.put("SubnetArns", SUBNET_ARNS_FIELD);
        map.put("Options", OPTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcAttachmentRequest, T> g) {
        return obj -> g.apply((CreateVpcAttachmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String coreNetworkId;
        private String vpcArn;
        private List<String> subnetArns = DefaultSdkAutoConstructList.getInstance();
        private VpcOptions options;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcAttachmentRequest model) {
            super(model);
            this.coreNetworkId(model.coreNetworkId);
            this.vpcArn(model.vpcArn);
            this.subnetArns(model.subnetArns);
            this.options(model.options);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getVpcArn() {
            return this.vpcArn;
        }

        public final void setVpcArn(String vpcArn) {
            this.vpcArn = vpcArn;
        }

        @Override
        public final Builder vpcArn(String vpcArn) {
            this.vpcArn = vpcArn;
            return this;
        }

        public final Collection<String> getSubnetArns() {
            if (this.subnetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetArns;
        }

        public final void setSubnetArns(Collection<String> subnetArns) {
            this.subnetArns = SubnetArnListCopier.copy(subnetArns);
        }

        @Override
        public final Builder subnetArns(Collection<String> subnetArns) {
            this.subnetArns = SubnetArnListCopier.copy(subnetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetArns(String ... subnetArns) {
            this.subnetArns(Arrays.asList(subnetArns));
            return this;
        }

        public final VpcOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(VpcOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(VpcOptions options) {
            this.options = options;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcAttachmentRequest build() {
            return new CreateVpcAttachmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcAttachmentRequest> {
        public Builder coreNetworkId(String var1);

        public Builder vpcArn(String var1);

        public Builder subnetArns(Collection<String> var1);

        public Builder subnetArns(String ... var1);

        public Builder options(VpcOptions var1);

        default public Builder options(Consumer<VpcOptions.Builder> options) {
            return this.options((VpcOptions)((VpcOptions.Builder)VpcOptions.builder().applyMutation(options)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

