/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse;
import software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociation;

public class GetTransitGatewayConnectPeerAssociationsIterable
implements SdkIterable<GetTransitGatewayConnectPeerAssociationsResponse> {
    private final NetworkManagerClient client;
    private final GetTransitGatewayConnectPeerAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTransitGatewayConnectPeerAssociationsIterable(NetworkManagerClient client, GetTransitGatewayConnectPeerAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetTransitGatewayConnectPeerAssociationsResponseFetcher();
    }

    public Iterator<GetTransitGatewayConnectPeerAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayConnectPeerAssociation> transitGatewayConnectPeerAssociations() {
        Function<GetTransitGatewayConnectPeerAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayConnectPeerAssociations() != null) {
                return response.transitGatewayConnectPeerAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetTransitGatewayConnectPeerAssociationsResponseFetcher
    implements SyncPageFetcher<GetTransitGatewayConnectPeerAssociationsResponse> {
        private GetTransitGatewayConnectPeerAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetTransitGatewayConnectPeerAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetTransitGatewayConnectPeerAssociationsResponse nextPage(GetTransitGatewayConnectPeerAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetTransitGatewayConnectPeerAssociationsIterable.this.client.getTransitGatewayConnectPeerAssociations(GetTransitGatewayConnectPeerAssociationsIterable.this.firstRequest);
            }
            return GetTransitGatewayConnectPeerAssociationsIterable.this.client.getTransitGatewayConnectPeerAssociations((GetTransitGatewayConnectPeerAssociationsRequest)((Object)GetTransitGatewayConnectPeerAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

