/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation;
import software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse;

public class GetCustomerGatewayAssociationsPublisher
implements SdkPublisher<GetCustomerGatewayAssociationsResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetCustomerGatewayAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCustomerGatewayAssociationsPublisher(NetworkManagerAsyncClient client, GetCustomerGatewayAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCustomerGatewayAssociationsPublisher(NetworkManagerAsyncClient client, GetCustomerGatewayAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCustomerGatewayAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCustomerGatewayAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomerGatewayAssociation> customerGatewayAssociations() {
        Function<GetCustomerGatewayAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customerGatewayAssociations() != null) {
                return response.customerGatewayAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetCustomerGatewayAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetCustomerGatewayAssociationsResponseFetcher
    implements AsyncPageFetcher<GetCustomerGatewayAssociationsResponse> {
        private GetCustomerGatewayAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetCustomerGatewayAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCustomerGatewayAssociationsResponse> nextPage(GetCustomerGatewayAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetCustomerGatewayAssociationsPublisher.this.client.getCustomerGatewayAssociations(GetCustomerGatewayAssociationsPublisher.this.firstRequest);
            }
            return GetCustomerGatewayAssociationsPublisher.this.client.getCustomerGatewayAssociations((GetCustomerGatewayAssociationsRequest)((Object)GetCustomerGatewayAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

