/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkmanager.model.ReasonContextMapCopier;
import software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionReasonCode;
import software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletionResultCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteAnalysisCompletion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteAnalysisCompletion> {
    private static final SdkField<String> RESULT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultCode").getter(RouteAnalysisCompletion.getter(RouteAnalysisCompletion::resultCodeAsString)).setter(RouteAnalysisCompletion.setter(Builder::resultCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultCode").build()}).build();
    private static final SdkField<String> REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReasonCode").getter(RouteAnalysisCompletion.getter(RouteAnalysisCompletion::reasonCodeAsString)).setter(RouteAnalysisCompletion.setter(Builder::reasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonCode").build()}).build();
    private static final SdkField<Map<String, String>> REASON_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ReasonContext").getter(RouteAnalysisCompletion.getter(RouteAnalysisCompletion::reasonContext)).setter(RouteAnalysisCompletion.setter(Builder::reasonContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_CODE_FIELD, REASON_CODE_FIELD, REASON_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteAnalysisCompletion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resultCode;
    private final String reasonCode;
    private final Map<String, String> reasonContext;

    private RouteAnalysisCompletion(BuilderImpl builder) {
        this.resultCode = builder.resultCode;
        this.reasonCode = builder.reasonCode;
        this.reasonContext = builder.reasonContext;
    }

    public final RouteAnalysisCompletionResultCode resultCode() {
        return RouteAnalysisCompletionResultCode.fromValue(this.resultCode);
    }

    public final String resultCodeAsString() {
        return this.resultCode;
    }

    public final RouteAnalysisCompletionReasonCode reasonCode() {
        return RouteAnalysisCompletionReasonCode.fromValue(this.reasonCode);
    }

    public final String reasonCodeAsString() {
        return this.reasonCode;
    }

    public final boolean hasReasonContext() {
        return this.reasonContext != null && !(this.reasonContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> reasonContext() {
        return this.reasonContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReasonContext() ? this.reasonContext() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAnalysisCompletion)) {
            return false;
        }
        RouteAnalysisCompletion other = (RouteAnalysisCompletion)obj;
        return Objects.equals(this.resultCodeAsString(), other.resultCodeAsString()) && Objects.equals(this.reasonCodeAsString(), other.reasonCodeAsString()) && this.hasReasonContext() == other.hasReasonContext() && Objects.equals(this.reasonContext(), other.reasonContext());
    }

    public final String toString() {
        return ToString.builder((String)"RouteAnalysisCompletion").add("ResultCode", (Object)this.resultCodeAsString()).add("ReasonCode", (Object)this.reasonCodeAsString()).add("ReasonContext", this.hasReasonContext() ? this.reasonContext() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultCode": {
                return Optional.ofNullable(clazz.cast(this.resultCodeAsString()));
            }
            case "ReasonCode": {
                return Optional.ofNullable(clazz.cast(this.reasonCodeAsString()));
            }
            case "ReasonContext": {
                return Optional.ofNullable(clazz.cast(this.reasonContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResultCode", RESULT_CODE_FIELD);
        map.put("ReasonCode", REASON_CODE_FIELD);
        map.put("ReasonContext", REASON_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteAnalysisCompletion, T> g) {
        return obj -> g.apply((RouteAnalysisCompletion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resultCode;
        private String reasonCode;
        private Map<String, String> reasonContext = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteAnalysisCompletion model) {
            this.resultCode(model.resultCode);
            this.reasonCode(model.reasonCode);
            this.reasonContext(model.reasonContext);
        }

        public final String getResultCode() {
            return this.resultCode;
        }

        public final void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        @Override
        public final Builder resultCode(String resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        @Override
        public final Builder resultCode(RouteAnalysisCompletionResultCode resultCode) {
            this.resultCode(resultCode == null ? null : resultCode.toString());
            return this;
        }

        public final String getReasonCode() {
            return this.reasonCode;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        @Override
        public final Builder reasonCode(RouteAnalysisCompletionReasonCode reasonCode) {
            this.reasonCode(reasonCode == null ? null : reasonCode.toString());
            return this;
        }

        public final Map<String, String> getReasonContext() {
            if (this.reasonContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.reasonContext;
        }

        public final void setReasonContext(Map<String, String> reasonContext) {
            this.reasonContext = ReasonContextMapCopier.copy(reasonContext);
        }

        @Override
        public final Builder reasonContext(Map<String, String> reasonContext) {
            this.reasonContext = ReasonContextMapCopier.copy(reasonContext);
            return this;
        }

        public RouteAnalysisCompletion build() {
            return new RouteAnalysisCompletion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteAnalysisCompletion> {
        public Builder resultCode(String var1);

        public Builder resultCode(RouteAnalysisCompletionResultCode var1);

        public Builder reasonCode(String var1);

        public Builder reasonCode(RouteAnalysisCompletionReasonCode var1);

        public Builder reasonContext(Map<String, String> var1);
    }
}

