/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListProxyRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleGroupMetadata;

public class ListProxyRuleGroupsPublisher
implements SdkPublisher<ListProxyRuleGroupsResponse> {
    private final NetworkFirewallAsyncClient client;
    private final ListProxyRuleGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProxyRuleGroupsPublisher(NetworkFirewallAsyncClient client, ListProxyRuleGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProxyRuleGroupsPublisher(NetworkFirewallAsyncClient client, ListProxyRuleGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProxyRuleGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProxyRuleGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProxyRuleGroupMetadata> proxyRuleGroups() {
        Function<ListProxyRuleGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.proxyRuleGroups() != null) {
                return response.proxyRuleGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProxyRuleGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProxyRuleGroupsResponseFetcher
    implements AsyncPageFetcher<ListProxyRuleGroupsResponse> {
        private ListProxyRuleGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListProxyRuleGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProxyRuleGroupsResponse> nextPage(ListProxyRuleGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListProxyRuleGroupsPublisher.this.client.listProxyRuleGroups(ListProxyRuleGroupsPublisher.this.firstRequest);
            }
            return ListProxyRuleGroupsPublisher.this.client.listProxyRuleGroups((ListProxyRuleGroupsRequest)((Object)ListProxyRuleGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

