/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.VpcEndpointAssociationMetadata;
import software.amazon.awssdk.services.networkfirewall.model.VpcEndpointAssociationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVpcEndpointAssociationsResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, ListVpcEndpointAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVpcEndpointAssociationsResponse.getter(ListVpcEndpointAssociationsResponse::nextToken)).setter(ListVpcEndpointAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<VpcEndpointAssociationMetadata>> VPC_ENDPOINT_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcEndpointAssociations").getter(ListVpcEndpointAssociationsResponse.getter(ListVpcEndpointAssociationsResponse::vpcEndpointAssociations)).setter(ListVpcEndpointAssociationsResponse.setter(Builder::vpcEndpointAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcEndpointAssociationMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VPC_ENDPOINT_ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVpcEndpointAssociationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<VpcEndpointAssociationMetadata> vpcEndpointAssociations;

    private ListVpcEndpointAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vpcEndpointAssociations = builder.vpcEndpointAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasVpcEndpointAssociations() {
        return this.vpcEndpointAssociations != null && !(this.vpcEndpointAssociations instanceof SdkAutoConstructList);
    }

    public final List<VpcEndpointAssociationMetadata> vpcEndpointAssociations() {
        return this.vpcEndpointAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcEndpointAssociations() ? this.vpcEndpointAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcEndpointAssociationsResponse)) {
            return false;
        }
        ListVpcEndpointAssociationsResponse other = (ListVpcEndpointAssociationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasVpcEndpointAssociations() == other.hasVpcEndpointAssociations() && Objects.equals(this.vpcEndpointAssociations(), other.vpcEndpointAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"ListVpcEndpointAssociationsResponse").add("NextToken", (Object)this.nextToken()).add("VpcEndpointAssociations", this.hasVpcEndpointAssociations() ? this.vpcEndpointAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "VpcEndpointAssociations": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("VpcEndpointAssociations", VPC_ENDPOINT_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVpcEndpointAssociationsResponse, T> g) {
        return obj -> g.apply((ListVpcEndpointAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VpcEndpointAssociationMetadata> vpcEndpointAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcEndpointAssociationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.vpcEndpointAssociations(model.vpcEndpointAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VpcEndpointAssociationMetadata.Builder> getVpcEndpointAssociations() {
            List<VpcEndpointAssociationMetadata.Builder> result = VpcEndpointAssociationsCopier.copyToBuilder(this.vpcEndpointAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpointAssociations(Collection<VpcEndpointAssociationMetadata.BuilderImpl> vpcEndpointAssociations) {
            this.vpcEndpointAssociations = VpcEndpointAssociationsCopier.copyFromBuilder(vpcEndpointAssociations);
        }

        @Override
        public final Builder vpcEndpointAssociations(Collection<VpcEndpointAssociationMetadata> vpcEndpointAssociations) {
            this.vpcEndpointAssociations = VpcEndpointAssociationsCopier.copy(vpcEndpointAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointAssociations(VpcEndpointAssociationMetadata ... vpcEndpointAssociations) {
            this.vpcEndpointAssociations(Arrays.asList(vpcEndpointAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointAssociations(Consumer<VpcEndpointAssociationMetadata.Builder> ... vpcEndpointAssociations) {
            this.vpcEndpointAssociations(Stream.of(vpcEndpointAssociations).map(c -> (VpcEndpointAssociationMetadata)((VpcEndpointAssociationMetadata.Builder)VpcEndpointAssociationMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVpcEndpointAssociationsResponse build() {
            return new ListVpcEndpointAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVpcEndpointAssociationsResponse> {
        public Builder nextToken(String var1);

        public Builder vpcEndpointAssociations(Collection<VpcEndpointAssociationMetadata> var1);

        public Builder vpcEndpointAssociations(VpcEndpointAssociationMetadata ... var1);

        public Builder vpcEndpointAssociations(Consumer<VpcEndpointAssociationMetadata.Builder> ... var1);
    }
}

