/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.ProxyConfigDefaultRulePhaseActionsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ResourceArnListCopier;
import software.amazon.awssdk.services.networkfirewall.model.ResourceNameListCopier;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProxyConfigurationRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, CreateProxyConfigurationRequest> {
    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationName").getter(CreateProxyConfigurationRequest.getter(CreateProxyConfigurationRequest::proxyConfigurationName)).setter(CreateProxyConfigurationRequest.setter(Builder::proxyConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateProxyConfigurationRequest.getter(CreateProxyConfigurationRequest::description)).setter(CreateProxyConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> RULE_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleGroupNames").getter(CreateProxyConfigurationRequest.getter(CreateProxyConfigurationRequest::ruleGroupNames)).setter(CreateProxyConfigurationRequest.setter(Builder::ruleGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RULE_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleGroupArns").getter(CreateProxyConfigurationRequest.getter(CreateProxyConfigurationRequest::ruleGroupArns)).setter(CreateProxyConfigurationRequest.setter(Builder::ruleGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProxyConfigDefaultRulePhaseActionsRequest> DEFAULT_RULE_PHASE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultRulePhaseActions").getter(CreateProxyConfigurationRequest.getter(CreateProxyConfigurationRequest::defaultRulePhaseActions)).setter(CreateProxyConfigurationRequest.setter(Builder::defaultRulePhaseActions)).constructor(ProxyConfigDefaultRulePhaseActionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRulePhaseActions").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateProxyConfigurationRequest.getter(CreateProxyConfigurationRequest::tags)).setter(CreateProxyConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_CONFIGURATION_NAME_FIELD, DESCRIPTION_FIELD, RULE_GROUP_NAMES_FIELD, RULE_GROUP_ARNS_FIELD, DEFAULT_RULE_PHASE_ACTIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProxyConfigurationRequest.memberNameToFieldInitializer();
    private final String proxyConfigurationName;
    private final String description;
    private final List<String> ruleGroupNames;
    private final List<String> ruleGroupArns;
    private final ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions;
    private final List<Tag> tags;

    private CreateProxyConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.description = builder.description;
        this.ruleGroupNames = builder.ruleGroupNames;
        this.ruleGroupArns = builder.ruleGroupArns;
        this.defaultRulePhaseActions = builder.defaultRulePhaseActions;
        this.tags = builder.tags;
    }

    public final String proxyConfigurationName() {
        return this.proxyConfigurationName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRuleGroupNames() {
        return this.ruleGroupNames != null && !(this.ruleGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> ruleGroupNames() {
        return this.ruleGroupNames;
    }

    public final boolean hasRuleGroupArns() {
        return this.ruleGroupArns != null && !(this.ruleGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> ruleGroupArns() {
        return this.ruleGroupArns;
    }

    public final ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions() {
        return this.defaultRulePhaseActions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleGroupNames() ? this.ruleGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleGroupArns() ? this.ruleGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRulePhaseActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProxyConfigurationRequest)) {
            return false;
        }
        CreateProxyConfigurationRequest other = (CreateProxyConfigurationRequest)((Object)obj);
        return Objects.equals(this.proxyConfigurationName(), other.proxyConfigurationName()) && Objects.equals(this.description(), other.description()) && this.hasRuleGroupNames() == other.hasRuleGroupNames() && Objects.equals(this.ruleGroupNames(), other.ruleGroupNames()) && this.hasRuleGroupArns() == other.hasRuleGroupArns() && Objects.equals(this.ruleGroupArns(), other.ruleGroupArns()) && Objects.equals(this.defaultRulePhaseActions(), other.defaultRulePhaseActions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProxyConfigurationRequest").add("ProxyConfigurationName", (Object)this.proxyConfigurationName()).add("Description", (Object)this.description()).add("RuleGroupNames", this.hasRuleGroupNames() ? this.ruleGroupNames() : null).add("RuleGroupArns", this.hasRuleGroupArns() ? this.ruleGroupArns() : null).add("DefaultRulePhaseActions", (Object)this.defaultRulePhaseActions()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RuleGroupNames": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupNames()));
            }
            case "RuleGroupArns": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupArns()));
            }
            case "DefaultRulePhaseActions": {
                return Optional.ofNullable(clazz.cast(this.defaultRulePhaseActions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RuleGroupNames", RULE_GROUP_NAMES_FIELD);
        map.put("RuleGroupArns", RULE_GROUP_ARNS_FIELD);
        map.put("DefaultRulePhaseActions", DEFAULT_RULE_PHASE_ACTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProxyConfigurationRequest, T> g) {
        return obj -> g.apply((CreateProxyConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String proxyConfigurationName;
        private String description;
        private List<String> ruleGroupNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> ruleGroupArns = DefaultSdkAutoConstructList.getInstance();
        private ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProxyConfigurationRequest model) {
            super(model);
            this.proxyConfigurationName(model.proxyConfigurationName);
            this.description(model.description);
            this.ruleGroupNames(model.ruleGroupNames);
            this.ruleGroupArns(model.ruleGroupArns);
            this.defaultRulePhaseActions(model.defaultRulePhaseActions);
            this.tags(model.tags);
        }

        public final String getProxyConfigurationName() {
            return this.proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getRuleGroupNames() {
            if (this.ruleGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleGroupNames;
        }

        public final void setRuleGroupNames(Collection<String> ruleGroupNames) {
            this.ruleGroupNames = ResourceNameListCopier.copy(ruleGroupNames);
        }

        @Override
        public final Builder ruleGroupNames(Collection<String> ruleGroupNames) {
            this.ruleGroupNames = ResourceNameListCopier.copy(ruleGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupNames(String ... ruleGroupNames) {
            this.ruleGroupNames(Arrays.asList(ruleGroupNames));
            return this;
        }

        public final Collection<String> getRuleGroupArns() {
            if (this.ruleGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleGroupArns;
        }

        public final void setRuleGroupArns(Collection<String> ruleGroupArns) {
            this.ruleGroupArns = ResourceArnListCopier.copy(ruleGroupArns);
        }

        @Override
        public final Builder ruleGroupArns(Collection<String> ruleGroupArns) {
            this.ruleGroupArns = ResourceArnListCopier.copy(ruleGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupArns(String ... ruleGroupArns) {
            this.ruleGroupArns(Arrays.asList(ruleGroupArns));
            return this;
        }

        public final ProxyConfigDefaultRulePhaseActionsRequest.Builder getDefaultRulePhaseActions() {
            return this.defaultRulePhaseActions != null ? this.defaultRulePhaseActions.toBuilder() : null;
        }

        public final void setDefaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest.BuilderImpl defaultRulePhaseActions) {
            this.defaultRulePhaseActions = defaultRulePhaseActions != null ? defaultRulePhaseActions.build() : null;
        }

        @Override
        public final Builder defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions) {
            this.defaultRulePhaseActions = defaultRulePhaseActions;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProxyConfigurationRequest build() {
            return new CreateProxyConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProxyConfigurationRequest> {
        public Builder proxyConfigurationName(String var1);

        public Builder description(String var1);

        public Builder ruleGroupNames(Collection<String> var1);

        public Builder ruleGroupNames(String ... var1);

        public Builder ruleGroupArns(Collection<String> var1);

        public Builder ruleGroupArns(String ... var1);

        public Builder defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest var1);

        default public Builder defaultRulePhaseActions(Consumer<ProxyConfigDefaultRulePhaseActionsRequest.Builder> defaultRulePhaseActions) {
            return this.defaultRulePhaseActions((ProxyConfigDefaultRulePhaseActionsRequest)((ProxyConfigDefaultRulePhaseActionsRequest.Builder)ProxyConfigDefaultRulePhaseActionsRequest.builder().applyMutation(defaultRulePhaseActions)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

