/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.AvailabilityZoneMapping;
import software.amazon.awssdk.services.networkfirewall.model.AvailabilityZoneMappingsCopier;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateAvailabilityZonesResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, DisassociateAvailabilityZonesResponse> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(DisassociateAvailabilityZonesResponse.getter(DisassociateAvailabilityZonesResponse::firewallArn)).setter(DisassociateAvailabilityZonesResponse.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallName").getter(DisassociateAvailabilityZonesResponse.getter(DisassociateAvailabilityZonesResponse::firewallName)).setter(DisassociateAvailabilityZonesResponse.setter(Builder::firewallName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()}).build();
    private static final SdkField<List<AvailabilityZoneMapping>> AVAILABILITY_ZONE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZoneMappings").getter(DisassociateAvailabilityZonesResponse.getter(DisassociateAvailabilityZonesResponse::availabilityZoneMappings)).setter(DisassociateAvailabilityZonesResponse.setter(Builder::availabilityZoneMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZoneMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(DisassociateAvailabilityZonesResponse.getter(DisassociateAvailabilityZonesResponse::updateToken)).setter(DisassociateAvailabilityZonesResponse.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD, FIREWALL_NAME_FIELD, AVAILABILITY_ZONE_MAPPINGS_FIELD, UPDATE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateAvailabilityZonesResponse.memberNameToFieldInitializer();
    private final String firewallArn;
    private final String firewallName;
    private final List<AvailabilityZoneMapping> availabilityZoneMappings;
    private final String updateToken;

    private DisassociateAvailabilityZonesResponse(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.firewallName = builder.firewallName;
        this.availabilityZoneMappings = builder.availabilityZoneMappings;
        this.updateToken = builder.updateToken;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final String firewallName() {
        return this.firewallName;
    }

    public final boolean hasAvailabilityZoneMappings() {
        return this.availabilityZoneMappings != null && !(this.availabilityZoneMappings instanceof SdkAutoConstructList);
    }

    public final List<AvailabilityZoneMapping> availabilityZoneMappings() {
        return this.availabilityZoneMappings;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZoneMappings() ? this.availabilityZoneMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateAvailabilityZonesResponse)) {
            return false;
        }
        DisassociateAvailabilityZonesResponse other = (DisassociateAvailabilityZonesResponse)((Object)obj);
        return Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.firewallName(), other.firewallName()) && this.hasAvailabilityZoneMappings() == other.hasAvailabilityZoneMappings() && Objects.equals(this.availabilityZoneMappings(), other.availabilityZoneMappings()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateAvailabilityZonesResponse").add("FirewallArn", (Object)this.firewallArn()).add("FirewallName", (Object)this.firewallName()).add("AvailabilityZoneMappings", this.hasAvailabilityZoneMappings() ? this.availabilityZoneMappings() : null).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "FirewallName": {
                return Optional.ofNullable(clazz.cast(this.firewallName()));
            }
            case "AvailabilityZoneMappings": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneMappings()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("FirewallName", FIREWALL_NAME_FIELD);
        map.put("AvailabilityZoneMappings", AVAILABILITY_ZONE_MAPPINGS_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateAvailabilityZonesResponse, T> g) {
        return obj -> g.apply((DisassociateAvailabilityZonesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private String firewallArn;
        private String firewallName;
        private List<AvailabilityZoneMapping> availabilityZoneMappings = DefaultSdkAutoConstructList.getInstance();
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateAvailabilityZonesResponse model) {
            super(model);
            this.firewallArn(model.firewallArn);
            this.firewallName(model.firewallName);
            this.availabilityZoneMappings(model.availabilityZoneMappings);
            this.updateToken(model.updateToken);
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getFirewallName() {
            return this.firewallName;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        @Override
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final List<AvailabilityZoneMapping.Builder> getAvailabilityZoneMappings() {
            List<AvailabilityZoneMapping.Builder> result = AvailabilityZoneMappingsCopier.copyToBuilder(this.availabilityZoneMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZoneMappings(Collection<AvailabilityZoneMapping.BuilderImpl> availabilityZoneMappings) {
            this.availabilityZoneMappings = AvailabilityZoneMappingsCopier.copyFromBuilder(availabilityZoneMappings);
        }

        @Override
        public final Builder availabilityZoneMappings(Collection<AvailabilityZoneMapping> availabilityZoneMappings) {
            this.availabilityZoneMappings = AvailabilityZoneMappingsCopier.copy(availabilityZoneMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneMappings(AvailabilityZoneMapping ... availabilityZoneMappings) {
            this.availabilityZoneMappings(Arrays.asList(availabilityZoneMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneMappings(Consumer<AvailabilityZoneMapping.Builder> ... availabilityZoneMappings) {
            this.availabilityZoneMappings(Stream.of(availabilityZoneMappings).map(c -> (AvailabilityZoneMapping)((AvailabilityZoneMapping.Builder)AvailabilityZoneMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public DisassociateAvailabilityZonesResponse build() {
            return new DisassociateAvailabilityZonesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateAvailabilityZonesResponse> {
        public Builder firewallArn(String var1);

        public Builder firewallName(String var1);

        public Builder availabilityZoneMappings(Collection<AvailabilityZoneMapping> var1);

        public Builder availabilityZoneMappings(AvailabilityZoneMapping ... var1);

        public Builder availabilityZoneMappings(Consumer<AvailabilityZoneMapping.Builder> ... var1);

        public Builder updateToken(String var1);
    }
}

