/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.SubnetMapping;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcEndpointAssociationRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, CreateVpcEndpointAssociationRequest> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(CreateVpcEndpointAssociationRequest.getter(CreateVpcEndpointAssociationRequest::firewallArn)).setter(CreateVpcEndpointAssociationRequest.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(CreateVpcEndpointAssociationRequest.getter(CreateVpcEndpointAssociationRequest::vpcId)).setter(CreateVpcEndpointAssociationRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<SubnetMapping> SUBNET_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SubnetMapping").getter(CreateVpcEndpointAssociationRequest.getter(CreateVpcEndpointAssociationRequest::subnetMapping)).setter(CreateVpcEndpointAssociationRequest.setter(Builder::subnetMapping)).constructor(SubnetMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMapping").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateVpcEndpointAssociationRequest.getter(CreateVpcEndpointAssociationRequest::description)).setter(CreateVpcEndpointAssociationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateVpcEndpointAssociationRequest.getter(CreateVpcEndpointAssociationRequest::tags)).setter(CreateVpcEndpointAssociationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD, VPC_ID_FIELD, SUBNET_MAPPING_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVpcEndpointAssociationRequest.memberNameToFieldInitializer();
    private final String firewallArn;
    private final String vpcId;
    private final SubnetMapping subnetMapping;
    private final String description;
    private final List<Tag> tags;

    private CreateVpcEndpointAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.vpcId = builder.vpcId;
        this.subnetMapping = builder.subnetMapping;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final SubnetMapping subnetMapping() {
        return this.subnetMapping;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointAssociationRequest)) {
            return false;
        }
        CreateVpcEndpointAssociationRequest other = (CreateVpcEndpointAssociationRequest)((Object)obj);
        return Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetMapping(), other.subnetMapping()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcEndpointAssociationRequest").add("FirewallArn", (Object)this.firewallArn()).add("VpcId", (Object)this.vpcId()).add("SubnetMapping", (Object)this.subnetMapping()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetMapping": {
                return Optional.ofNullable(clazz.cast(this.subnetMapping()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetMapping", SUBNET_MAPPING_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointAssociationRequest, T> g) {
        return obj -> g.apply((CreateVpcEndpointAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String firewallArn;
        private String vpcId;
        private SubnetMapping subnetMapping;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointAssociationRequest model) {
            super(model);
            this.firewallArn(model.firewallArn);
            this.vpcId(model.vpcId);
            this.subnetMapping(model.subnetMapping);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final SubnetMapping.Builder getSubnetMapping() {
            return this.subnetMapping != null ? this.subnetMapping.toBuilder() : null;
        }

        public final void setSubnetMapping(SubnetMapping.BuilderImpl subnetMapping) {
            this.subnetMapping = subnetMapping != null ? subnetMapping.build() : null;
        }

        @Override
        public final Builder subnetMapping(SubnetMapping subnetMapping) {
            this.subnetMapping = subnetMapping;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcEndpointAssociationRequest build() {
            return new CreateVpcEndpointAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcEndpointAssociationRequest> {
        public Builder firewallArn(String var1);

        public Builder vpcId(String var1);

        public Builder subnetMapping(SubnetMapping var1);

        default public Builder subnetMapping(Consumer<SubnetMapping.Builder> subnetMapping) {
            return this.subnetMapping((SubnetMapping)((SubnetMapping.Builder)SubnetMapping.builder().applyMutation(subnetMapping)).build());
        }

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

