/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.FlowOperationMetadata;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsResponse;

public class ListFlowOperationsIterable
implements SdkIterable<ListFlowOperationsResponse> {
    private final NetworkFirewallClient client;
    private final ListFlowOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlowOperationsIterable(NetworkFirewallClient client, ListFlowOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFlowOperationsResponseFetcher();
    }

    public Iterator<ListFlowOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowOperationMetadata> flowOperations() {
        Function<ListFlowOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowOperations() != null) {
                return response.flowOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFlowOperationsResponseFetcher
    implements SyncPageFetcher<ListFlowOperationsResponse> {
        private ListFlowOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlowOperationsResponse nextPage(ListFlowOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowOperationsIterable.this.client.listFlowOperations(ListFlowOperationsIterable.this.firstRequest);
            }
            return ListFlowOperationsIterable.this.client.listFlowOperations((ListFlowOperationsRequest)((Object)ListFlowOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

