/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.AnalysisTypeReportResult;
import software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsRequest;
import software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsResponse;

public class GetAnalysisReportResultsIterable
implements SdkIterable<GetAnalysisReportResultsResponse> {
    private final NetworkFirewallClient client;
    private final GetAnalysisReportResultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAnalysisReportResultsIterable(NetworkFirewallClient client, GetAnalysisReportResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetAnalysisReportResultsResponseFetcher();
    }

    public Iterator<GetAnalysisReportResultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnalysisTypeReportResult> analysisReportResults() {
        Function<GetAnalysisReportResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.analysisReportResults() != null) {
                return response.analysisReportResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetAnalysisReportResultsResponseFetcher
    implements SyncPageFetcher<GetAnalysisReportResultsResponse> {
        private GetAnalysisReportResultsResponseFetcher() {
        }

        public boolean hasNextPage(GetAnalysisReportResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetAnalysisReportResultsResponse nextPage(GetAnalysisReportResultsResponse previousPage) {
            if (previousPage == null) {
                return GetAnalysisReportResultsIterable.this.client.getAnalysisReportResults(GetAnalysisReportResultsIterable.this.firstRequest);
            }
            return GetAnalysisReportResultsIterable.this.client.getAnalysisReportResults((GetAnalysisReportResultsRequest)((Object)GetAnalysisReportResultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

