/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.Flow;
import software.amazon.awssdk.services.networkfirewall.model.FlowOperationStatus;
import software.amazon.awssdk.services.networkfirewall.model.FlowsCopier;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFlowOperationResultsResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, ListFlowOperationResultsResponse> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(ListFlowOperationResultsResponse.getter(ListFlowOperationResultsResponse::firewallArn)).setter(ListFlowOperationResultsResponse.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ListFlowOperationResultsResponse.getter(ListFlowOperationResultsResponse::availabilityZone)).setter(ListFlowOperationResultsResponse.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> FLOW_OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOperationId").getter(ListFlowOperationResultsResponse.getter(ListFlowOperationResultsResponse::flowOperationId)).setter(ListFlowOperationResultsResponse.setter(Builder::flowOperationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationId").build()}).build();
    private static final SdkField<String> FLOW_OPERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOperationStatus").getter(ListFlowOperationResultsResponse.getter(ListFlowOperationResultsResponse::flowOperationStatusAsString)).setter(ListFlowOperationResultsResponse.setter(Builder::flowOperationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationStatus").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ListFlowOperationResultsResponse.getter(ListFlowOperationResultsResponse::statusMessage)).setter(ListFlowOperationResultsResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> FLOW_REQUEST_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FlowRequestTimestamp").getter(ListFlowOperationResultsResponse.getter(ListFlowOperationResultsResponse::flowRequestTimestamp)).setter(ListFlowOperationResultsResponse.setter(Builder::flowRequestTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowRequestTimestamp").build()}).build();
    private static final SdkField<List<Flow>> FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Flows").getter(ListFlowOperationResultsResponse.getter(ListFlowOperationResultsResponse::flows)).setter(ListFlowOperationResultsResponse.setter(Builder::flows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Flow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFlowOperationResultsResponse.getter(ListFlowOperationResultsResponse::nextToken)).setter(ListFlowOperationResultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD, AVAILABILITY_ZONE_FIELD, FLOW_OPERATION_ID_FIELD, FLOW_OPERATION_STATUS_FIELD, STATUS_MESSAGE_FIELD, FLOW_REQUEST_TIMESTAMP_FIELD, FLOWS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFlowOperationResultsResponse.memberNameToFieldInitializer();
    private final String firewallArn;
    private final String availabilityZone;
    private final String flowOperationId;
    private final String flowOperationStatus;
    private final String statusMessage;
    private final Instant flowRequestTimestamp;
    private final List<Flow> flows;
    private final String nextToken;

    private ListFlowOperationResultsResponse(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.availabilityZone = builder.availabilityZone;
        this.flowOperationId = builder.flowOperationId;
        this.flowOperationStatus = builder.flowOperationStatus;
        this.statusMessage = builder.statusMessage;
        this.flowRequestTimestamp = builder.flowRequestTimestamp;
        this.flows = builder.flows;
        this.nextToken = builder.nextToken;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String flowOperationId() {
        return this.flowOperationId;
    }

    public final FlowOperationStatus flowOperationStatus() {
        return FlowOperationStatus.fromValue(this.flowOperationStatus);
    }

    public final String flowOperationStatusAsString() {
        return this.flowOperationStatus;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant flowRequestTimestamp() {
        return this.flowRequestTimestamp;
    }

    public final boolean hasFlows() {
        return this.flows != null && !(this.flows instanceof SdkAutoConstructList);
    }

    public final List<Flow> flows() {
        return this.flows;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowRequestTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlows() ? this.flows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowOperationResultsResponse)) {
            return false;
        }
        ListFlowOperationResultsResponse other = (ListFlowOperationResultsResponse)((Object)obj);
        return Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.flowOperationId(), other.flowOperationId()) && Objects.equals(this.flowOperationStatusAsString(), other.flowOperationStatusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.flowRequestTimestamp(), other.flowRequestTimestamp()) && this.hasFlows() == other.hasFlows() && Objects.equals(this.flows(), other.flows()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFlowOperationResultsResponse").add("FirewallArn", (Object)this.firewallArn()).add("AvailabilityZone", (Object)this.availabilityZone()).add("FlowOperationId", (Object)this.flowOperationId()).add("FlowOperationStatus", (Object)this.flowOperationStatusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("FlowRequestTimestamp", (Object)this.flowRequestTimestamp()).add("Flows", this.hasFlows() ? this.flows() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "FlowOperationId": {
                return Optional.ofNullable(clazz.cast(this.flowOperationId()));
            }
            case "FlowOperationStatus": {
                return Optional.ofNullable(clazz.cast(this.flowOperationStatusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "FlowRequestTimestamp": {
                return Optional.ofNullable(clazz.cast(this.flowRequestTimestamp()));
            }
            case "Flows": {
                return Optional.ofNullable(clazz.cast(this.flows()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("FlowOperationId", FLOW_OPERATION_ID_FIELD);
        map.put("FlowOperationStatus", FLOW_OPERATION_STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("FlowRequestTimestamp", FLOW_REQUEST_TIMESTAMP_FIELD);
        map.put("Flows", FLOWS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFlowOperationResultsResponse, T> g) {
        return obj -> g.apply((ListFlowOperationResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private String firewallArn;
        private String availabilityZone;
        private String flowOperationId;
        private String flowOperationStatus;
        private String statusMessage;
        private Instant flowRequestTimestamp;
        private List<Flow> flows = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowOperationResultsResponse model) {
            super(model);
            this.firewallArn(model.firewallArn);
            this.availabilityZone(model.availabilityZone);
            this.flowOperationId(model.flowOperationId);
            this.flowOperationStatus(model.flowOperationStatus);
            this.statusMessage(model.statusMessage);
            this.flowRequestTimestamp(model.flowRequestTimestamp);
            this.flows(model.flows);
            this.nextToken(model.nextToken);
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getFlowOperationId() {
            return this.flowOperationId;
        }

        public final void setFlowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
        }

        @Override
        public final Builder flowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
            return this;
        }

        public final String getFlowOperationStatus() {
            return this.flowOperationStatus;
        }

        public final void setFlowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
        }

        @Override
        public final Builder flowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
            return this;
        }

        @Override
        public final Builder flowOperationStatus(FlowOperationStatus flowOperationStatus) {
            this.flowOperationStatus(flowOperationStatus == null ? null : flowOperationStatus.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getFlowRequestTimestamp() {
            return this.flowRequestTimestamp;
        }

        public final void setFlowRequestTimestamp(Instant flowRequestTimestamp) {
            this.flowRequestTimestamp = flowRequestTimestamp;
        }

        @Override
        public final Builder flowRequestTimestamp(Instant flowRequestTimestamp) {
            this.flowRequestTimestamp = flowRequestTimestamp;
            return this;
        }

        public final List<Flow.Builder> getFlows() {
            List<Flow.Builder> result = FlowsCopier.copyToBuilder(this.flows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlows(Collection<Flow.BuilderImpl> flows) {
            this.flows = FlowsCopier.copyFromBuilder(flows);
        }

        @Override
        public final Builder flows(Collection<Flow> flows) {
            this.flows = FlowsCopier.copy(flows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flows(Flow ... flows) {
            this.flows(Arrays.asList(flows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flows(Consumer<Flow.Builder> ... flows) {
            this.flows(Stream.of(flows).map(c -> (Flow)((Flow.Builder)Flow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFlowOperationResultsResponse build() {
            return new ListFlowOperationResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFlowOperationResultsResponse> {
        public Builder firewallArn(String var1);

        public Builder availabilityZone(String var1);

        public Builder flowOperationId(String var1);

        public Builder flowOperationStatus(String var1);

        public Builder flowOperationStatus(FlowOperationStatus var1);

        public Builder statusMessage(String var1);

        public Builder flowRequestTimestamp(Instant var1);

        public Builder flows(Collection<Flow> var1);

        public Builder flows(Flow ... var1);

        public Builder flows(Consumer<Flow.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

