/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MultiValueHandlingType {
    TO_LIST("TO_LIST"),
    PICK_FIRST("PICK_FIRST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MultiValueHandlingType> VALUE_MAP;
    private final String value;

    private MultiValueHandlingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MultiValueHandlingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MultiValueHandlingType> knownValues() {
        EnumSet<MultiValueHandlingType> knownValues = EnumSet.allOf(MultiValueHandlingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MultiValueHandlingType.class, MultiValueHandlingType::toString);
    }
}

