/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunegraph.model.ExportFilterPropertyAttributes;
import software.amazon.awssdk.services.neptunegraph.model.ExportFilterPropertyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportFilterElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportFilterElement> {
    private static final SdkField<Map<String, ExportFilterPropertyAttributes>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("properties").getter(ExportFilterElement.getter(ExportFilterElement::properties)).setter(ExportFilterElement.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportFilterPropertyAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportFilterElement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, ExportFilterPropertyAttributes> properties;

    private ExportFilterElement(BuilderImpl builder) {
        this.properties = builder.properties;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, ExportFilterPropertyAttributes> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportFilterElement)) {
            return false;
        }
        ExportFilterElement other = (ExportFilterElement)obj;
        return this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"ExportFilterElement").add("Properties", this.hasProperties() ? this.properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, ExportFilterPropertyAttributes>>> map = new HashMap<String, SdkField<Map<String, ExportFilterPropertyAttributes>>>();
        map.put("properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportFilterElement, T> g) {
        return obj -> g.apply((ExportFilterElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ExportFilterPropertyAttributes> properties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportFilterElement model) {
            this.properties(model.properties);
        }

        public final Map<String, ExportFilterPropertyAttributes.Builder> getProperties() {
            Map<String, ExportFilterPropertyAttributes.Builder> result = ExportFilterPropertyMapCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, ExportFilterPropertyAttributes.BuilderImpl> properties) {
            this.properties = ExportFilterPropertyMapCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, ExportFilterPropertyAttributes> properties) {
            this.properties = ExportFilterPropertyMapCopier.copy(properties);
            return this;
        }

        public ExportFilterElement build() {
            return new ExportFilterElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportFilterElement> {
        public Builder properties(Map<String, ExportFilterPropertyAttributes> var1);
    }
}

