/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImportTaskStatus {
    INITIALIZING("INITIALIZING"),
    EXPORTING("EXPORTING"),
    ANALYZING_DATA("ANALYZING_DATA"),
    IMPORTING("IMPORTING"),
    REPROVISIONING("REPROVISIONING"),
    ROLLING_BACK("ROLLING_BACK"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    CANCELLING("CANCELLING"),
    CANCELLED("CANCELLED"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImportTaskStatus> VALUE_MAP;
    private final String value;

    private ImportTaskStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImportTaskStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImportTaskStatus> knownValues() {
        EnumSet<ImportTaskStatus> knownValues = EnumSet.allOf(ImportTaskStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImportTaskStatus.class, ImportTaskStatus::toString);
    }
}

