/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.MlConfigDefinition;
import software.amazon.awssdk.services.neptunedata.model.MlResourceDefinition;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMlEndpointResponse
extends NeptunedataResponse
implements ToCopyableBuilder<Builder, GetMlEndpointResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetMlEndpointResponse.getter(GetMlEndpointResponse::status)).setter(GetMlEndpointResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetMlEndpointResponse.getter(GetMlEndpointResponse::id)).setter(GetMlEndpointResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<MlResourceDefinition> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("endpoint").getter(GetMlEndpointResponse.getter(GetMlEndpointResponse::endpoint)).setter(GetMlEndpointResponse.setter(Builder::endpoint)).constructor(MlResourceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<MlConfigDefinition> ENDPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("endpointConfig").getter(GetMlEndpointResponse.getter(GetMlEndpointResponse::endpointConfig)).setter(GetMlEndpointResponse.setter(Builder::endpointConfig)).constructor(MlConfigDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ID_FIELD, ENDPOINT_FIELD, ENDPOINT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMlEndpointResponse.memberNameToFieldInitializer();
    private final String status;
    private final String id;
    private final MlResourceDefinition endpoint;
    private final MlConfigDefinition endpointConfig;

    private GetMlEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.id = builder.id;
        this.endpoint = builder.endpoint;
        this.endpointConfig = builder.endpointConfig;
    }

    public final String status() {
        return this.status;
    }

    public final String id() {
        return this.id;
    }

    public final MlResourceDefinition endpoint() {
        return this.endpoint;
    }

    public final MlConfigDefinition endpointConfig() {
        return this.endpointConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlEndpointResponse)) {
            return false;
        }
        GetMlEndpointResponse other = (GetMlEndpointResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.endpointConfig(), other.endpointConfig());
    }

    public final String toString() {
        return ToString.builder((String)"GetMlEndpointResponse").add("Status", (Object)this.status()).add("Id", (Object)this.id()).add("Endpoint", (Object)this.endpoint()).add("EndpointConfig", (Object)this.endpointConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "endpointConfig": {
                return Optional.ofNullable(clazz.cast(this.endpointConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("id", ID_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("endpointConfig", ENDPOINT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMlEndpointResponse, T> g) {
        return obj -> g.apply((GetMlEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataResponse.BuilderImpl
    implements Builder {
        private String status;
        private String id;
        private MlResourceDefinition endpoint;
        private MlConfigDefinition endpointConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlEndpointResponse model) {
            super(model);
            this.status(model.status);
            this.id(model.id);
            this.endpoint(model.endpoint);
            this.endpointConfig(model.endpointConfig);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MlResourceDefinition.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        public final void setEndpoint(MlResourceDefinition.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(MlResourceDefinition endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final MlConfigDefinition.Builder getEndpointConfig() {
            return this.endpointConfig != null ? this.endpointConfig.toBuilder() : null;
        }

        public final void setEndpointConfig(MlConfigDefinition.BuilderImpl endpointConfig) {
            this.endpointConfig = endpointConfig != null ? endpointConfig.build() : null;
        }

        @Override
        public final Builder endpointConfig(MlConfigDefinition endpointConfig) {
            this.endpointConfig = endpointConfig;
            return this;
        }

        @Override
        public GetMlEndpointResponse build() {
            return new GetMlEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptunedataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMlEndpointResponse> {
        public Builder status(String var1);

        public Builder id(String var1);

        public Builder endpoint(MlResourceDefinition var1);

        default public Builder endpoint(Consumer<MlResourceDefinition.Builder> endpoint) {
            return this.endpoint((MlResourceDefinition)((MlResourceDefinition.Builder)MlResourceDefinition.builder().applyMutation(endpoint)).build());
        }

        public Builder endpointConfig(MlConfigDefinition var1);

        default public Builder endpointConfig(Consumer<MlConfigDefinition.Builder> endpointConfig) {
            return this.endpointConfig((MlConfigDefinition)((MlConfigDefinition.Builder)MlConfigDefinition.builder().applyMutation(endpointConfig)).build());
        }
    }
}

