/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Format {
    CSV("csv"),
    OPENCYPHER("opencypher"),
    NTRIPLES("ntriples"),
    NQUADS("nquads"),
    RDFXML("rdfxml"),
    TURTLE("turtle"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Format> VALUE_MAP;
    private final String value;

    private Format(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Format fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Format> knownValues() {
        EnumSet<Format> knownValues = EnumSet.allOf(Format.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Format.class, Format::toString);
    }
}

