/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.EventCategoriesListCopier;
import software.amazon.awssdk.services.neptune.model.NeptuneRequest;
import software.amazon.awssdk.services.neptune.model.SourceIdsListCopier;
import software.amazon.awssdk.services.neptune.model.Tag;
import software.amazon.awssdk.services.neptune.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEventSubscriptionRequest
extends NeptuneRequest
implements ToCopyableBuilder<Builder, CreateEventSubscriptionRequest> {
    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionName").getter(CreateEventSubscriptionRequest.getter(CreateEventSubscriptionRequest::subscriptionName)).setter(CreateEventSubscriptionRequest.setter(Builder::subscriptionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(CreateEventSubscriptionRequest.getter(CreateEventSubscriptionRequest::snsTopicArn)).setter(CreateEventSubscriptionRequest.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(CreateEventSubscriptionRequest.getter(CreateEventSubscriptionRequest::sourceType)).setter(CreateEventSubscriptionRequest.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventCategories").getter(CreateEventSubscriptionRequest.getter(CreateEventSubscriptionRequest::eventCategories)).setter(CreateEventSubscriptionRequest.setter(Builder::eventCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategories").build(), ListTrait.builder().memberLocationName("EventCategory").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategory").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceIds").getter(CreateEventSubscriptionRequest.getter(CreateEventSubscriptionRequest::sourceIds)).setter(CreateEventSubscriptionRequest.setter(Builder::sourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIds").build(), ListTrait.builder().memberLocationName("SourceId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(CreateEventSubscriptionRequest.getter(CreateEventSubscriptionRequest::enabled)).setter(CreateEventSubscriptionRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateEventSubscriptionRequest.getter(CreateEventSubscriptionRequest::tags)).setter(CreateEventSubscriptionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_NAME_FIELD, SNS_TOPIC_ARN_FIELD, SOURCE_TYPE_FIELD, EVENT_CATEGORIES_FIELD, SOURCE_IDS_FIELD, ENABLED_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEventSubscriptionRequest.memberNameToFieldInitializer();
    private final String subscriptionName;
    private final String snsTopicArn;
    private final String sourceType;
    private final List<String> eventCategories;
    private final List<String> sourceIds;
    private final Boolean enabled;
    private final List<Tag> tags;

    private CreateEventSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionName = builder.subscriptionName;
        this.snsTopicArn = builder.snsTopicArn;
        this.sourceType = builder.sourceType;
        this.eventCategories = builder.eventCategories;
        this.sourceIds = builder.sourceIds;
        this.enabled = builder.enabled;
        this.tags = builder.tags;
    }

    public final String subscriptionName() {
        return this.subscriptionName;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final String sourceType() {
        return this.sourceType;
    }

    public final boolean hasEventCategories() {
        return this.eventCategories != null && !(this.eventCategories instanceof SdkAutoConstructList);
    }

    public final List<String> eventCategories() {
        return this.eventCategories;
    }

    public final boolean hasSourceIds() {
        return this.sourceIds != null && !(this.sourceIds instanceof SdkAutoConstructList);
    }

    public final List<String> sourceIds() {
        return this.sourceIds;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventCategories() ? this.eventCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceIds() ? this.sourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventSubscriptionRequest)) {
            return false;
        }
        CreateEventSubscriptionRequest other = (CreateEventSubscriptionRequest)((Object)obj);
        return Objects.equals(this.subscriptionName(), other.subscriptionName()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.sourceType(), other.sourceType()) && this.hasEventCategories() == other.hasEventCategories() && Objects.equals(this.eventCategories(), other.eventCategories()) && this.hasSourceIds() == other.hasSourceIds() && Objects.equals(this.sourceIds(), other.sourceIds()) && Objects.equals(this.enabled(), other.enabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEventSubscriptionRequest").add("SubscriptionName", (Object)this.subscriptionName()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("SourceType", (Object)this.sourceType()).add("EventCategories", this.hasEventCategories() ? this.eventCategories() : null).add("SourceIds", this.hasSourceIds() ? this.sourceIds() : null).add("Enabled", (Object)this.enabled()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionName": {
                return Optional.ofNullable(clazz.cast(this.subscriptionName()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "EventCategories": {
                return Optional.ofNullable(clazz.cast(this.eventCategories()));
            }
            case "SourceIds": {
                return Optional.ofNullable(clazz.cast(this.sourceIds()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubscriptionName", SUBSCRIPTION_NAME_FIELD);
        map.put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("EventCategories", EVENT_CATEGORIES_FIELD);
        map.put("SourceIds", SOURCE_IDS_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEventSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateEventSubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneRequest.BuilderImpl
    implements Builder {
        private String subscriptionName;
        private String snsTopicArn;
        private String sourceType;
        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();
        private List<String> sourceIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean enabled;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventSubscriptionRequest model) {
            super(model);
            this.subscriptionName(model.subscriptionName);
            this.snsTopicArn(model.snsTopicArn);
            this.sourceType(model.sourceType);
            this.eventCategories(model.eventCategories);
            this.sourceIds(model.sourceIds);
            this.enabled(model.enabled);
            this.tags(model.tags);
        }

        public final String getSubscriptionName() {
            return this.subscriptionName;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final Collection<String> getEventCategories() {
            if (this.eventCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventCategories;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final Collection<String> getSourceIds() {
            if (this.sourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceIds;
        }

        public final void setSourceIds(Collection<String> sourceIds) {
            this.sourceIds = SourceIdsListCopier.copy(sourceIds);
        }

        @Override
        public final Builder sourceIds(Collection<String> sourceIds) {
            this.sourceIds = SourceIdsListCopier.copy(sourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceIds(String ... sourceIds) {
            this.sourceIds(Arrays.asList(sourceIds));
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventSubscriptionRequest build() {
            return new CreateEventSubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptuneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEventSubscriptionRequest> {
        public Builder subscriptionName(String var1);

        public Builder snsTopicArn(String var1);

        public Builder sourceType(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);

        public Builder sourceIds(Collection<String> var1);

        public Builder sourceIds(String ... var1);

        public Builder enabled(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

