/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptune.model.DBParameterGroup;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse;

public class DescribeDBParameterGroupsPublisher
implements SdkPublisher<DescribeDbParameterGroupsResponse> {
    private final NeptuneAsyncClient client;
    private final DescribeDbParameterGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBParameterGroupsPublisher(NeptuneAsyncClient client, DescribeDbParameterGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBParameterGroupsPublisher(NeptuneAsyncClient client, DescribeDbParameterGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbParameterGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbParameterGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBParameterGroup> dbParameterGroups() {
        Function<DescribeDbParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbParameterGroups() != null) {
                return response.dbParameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbParameterGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbParameterGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeDbParameterGroupsResponse> {
        private DescribeDbParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbParameterGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbParameterGroupsResponse> nextPage(DescribeDbParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBParameterGroupsPublisher.this.client.describeDBParameterGroups(DescribeDBParameterGroupsPublisher.this.firstRequest);
            }
            return DescribeDBParameterGroupsPublisher.this.client.describeDBParameterGroups((DescribeDbParameterGroupsRequest)((Object)DescribeDBParameterGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

