/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaaserverless.model.RunDetailSummary;
import software.amazon.awssdk.services.mwaaserverless.model.RunType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowRunSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowRunSummary> {
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(WorkflowRunSummary.getter(WorkflowRunSummary::runId)).setter(WorkflowRunSummary.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowArn").getter(WorkflowRunSummary.getter(WorkflowRunSummary::workflowArn)).setter(WorkflowRunSummary.setter(Builder::workflowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()}).build();
    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowVersion").getter(WorkflowRunSummary.getter(WorkflowRunSummary::workflowVersion)).setter(WorkflowRunSummary.setter(Builder::workflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()}).build();
    private static final SdkField<String> RUN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunType").getter(WorkflowRunSummary.getter(WorkflowRunSummary::runTypeAsString)).setter(WorkflowRunSummary.setter(Builder::runType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunType").build()}).build();
    private static final SdkField<RunDetailSummary> RUN_DETAIL_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RunDetailSummary").getter(WorkflowRunSummary.getter(WorkflowRunSummary::runDetailSummary)).setter(WorkflowRunSummary.setter(Builder::runDetailSummary)).constructor(RunDetailSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunDetailSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_ID_FIELD, WORKFLOW_ARN_FIELD, WORKFLOW_VERSION_FIELD, RUN_TYPE_FIELD, RUN_DETAIL_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkflowRunSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String runId;
    private final String workflowArn;
    private final String workflowVersion;
    private final String runType;
    private final RunDetailSummary runDetailSummary;

    private WorkflowRunSummary(BuilderImpl builder) {
        this.runId = builder.runId;
        this.workflowArn = builder.workflowArn;
        this.workflowVersion = builder.workflowVersion;
        this.runType = builder.runType;
        this.runDetailSummary = builder.runDetailSummary;
    }

    public final String runId() {
        return this.runId;
    }

    public final String workflowArn() {
        return this.workflowArn;
    }

    public final String workflowVersion() {
        return this.workflowVersion;
    }

    public final RunType runType() {
        return RunType.fromValue(this.runType);
    }

    public final String runTypeAsString() {
        return this.runType;
    }

    public final RunDetailSummary runDetailSummary() {
        return this.runDetailSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.runTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runDetailSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowRunSummary)) {
            return false;
        }
        WorkflowRunSummary other = (WorkflowRunSummary)obj;
        return Objects.equals(this.runId(), other.runId()) && Objects.equals(this.workflowArn(), other.workflowArn()) && Objects.equals(this.workflowVersion(), other.workflowVersion()) && Objects.equals(this.runTypeAsString(), other.runTypeAsString()) && Objects.equals(this.runDetailSummary(), other.runDetailSummary());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowRunSummary").add("RunId", (Object)this.runId()).add("WorkflowArn", (Object)this.workflowArn()).add("WorkflowVersion", (Object)this.workflowVersion()).add("RunType", (Object)this.runTypeAsString()).add("RunDetailSummary", (Object)this.runDetailSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "WorkflowArn": {
                return Optional.ofNullable(clazz.cast(this.workflowArn()));
            }
            case "WorkflowVersion": {
                return Optional.ofNullable(clazz.cast(this.workflowVersion()));
            }
            case "RunType": {
                return Optional.ofNullable(clazz.cast(this.runTypeAsString()));
            }
            case "RunDetailSummary": {
                return Optional.ofNullable(clazz.cast(this.runDetailSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RunId", RUN_ID_FIELD);
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("RunType", RUN_TYPE_FIELD);
        map.put("RunDetailSummary", RUN_DETAIL_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowRunSummary, T> g) {
        return obj -> g.apply((WorkflowRunSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String runId;
        private String workflowArn;
        private String workflowVersion;
        private String runType;
        private RunDetailSummary runDetailSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowRunSummary model) {
            this.runId(model.runId);
            this.workflowArn(model.workflowArn);
            this.workflowVersion(model.workflowVersion);
            this.runType(model.runType);
            this.runDetailSummary(model.runDetailSummary);
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getWorkflowArn() {
            return this.workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowVersion() {
            return this.workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final String getRunType() {
            return this.runType;
        }

        public final void setRunType(String runType) {
            this.runType = runType;
        }

        @Override
        public final Builder runType(String runType) {
            this.runType = runType;
            return this;
        }

        @Override
        public final Builder runType(RunType runType) {
            this.runType(runType == null ? null : runType.toString());
            return this;
        }

        public final RunDetailSummary.Builder getRunDetailSummary() {
            return this.runDetailSummary != null ? this.runDetailSummary.toBuilder() : null;
        }

        public final void setRunDetailSummary(RunDetailSummary.BuilderImpl runDetailSummary) {
            this.runDetailSummary = runDetailSummary != null ? runDetailSummary.build() : null;
        }

        @Override
        public final Builder runDetailSummary(RunDetailSummary runDetailSummary) {
            this.runDetailSummary = runDetailSummary;
            return this;
        }

        public WorkflowRunSummary build() {
            return new WorkflowRunSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowRunSummary> {
        public Builder runId(String var1);

        public Builder workflowArn(String var1);

        public Builder workflowVersion(String var1);

        public Builder runType(String var1);

        public Builder runType(RunType var1);

        public Builder runDetailSummary(RunDetailSummary var1);

        default public Builder runDetailSummary(Consumer<RunDetailSummary.Builder> runDetailSummary) {
            return this.runDetailSummary((RunDetailSummary)((RunDetailSummary.Builder)RunDetailSummary.builder().applyMutation(runDetailSummary)).build());
        }
    }
}

