/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaa.model.MwaaRequest;
import software.amazon.awssdk.services.mwaa.model.RestApiMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeRestApiRequest
extends MwaaRequest
implements ToCopyableBuilder<Builder, InvokeRestApiRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(InvokeRestApiRequest.getter(InvokeRestApiRequest::name)).setter(InvokeRestApiRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(InvokeRestApiRequest.getter(InvokeRestApiRequest::path)).setter(InvokeRestApiRequest.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Method").getter(InvokeRestApiRequest.getter(InvokeRestApiRequest::methodAsString)).setter(InvokeRestApiRequest.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").build()}).build();
    private static final SdkField<Document> QUERY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("QueryParameters").getter(InvokeRestApiRequest.getter(InvokeRestApiRequest::queryParameters)).setter(InvokeRestApiRequest.setter(Builder::queryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build()}).build();
    private static final SdkField<Document> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("Body").getter(InvokeRestApiRequest.getter(InvokeRestApiRequest::body)).setter(InvokeRestApiRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PATH_FIELD, METHOD_FIELD, QUERY_PARAMETERS_FIELD, BODY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeRestApiRequest.memberNameToFieldInitializer();
    private final String name;
    private final String path;
    private final String method;
    private final Document queryParameters;
    private final Document body;

    private InvokeRestApiRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.path = builder.path;
        this.method = builder.method;
        this.queryParameters = builder.queryParameters;
        this.body = builder.body;
    }

    public final String name() {
        return this.name;
    }

    public final String path() {
        return this.path;
    }

    public final RestApiMethod method() {
        return RestApiMethod.fromValue(this.method);
    }

    public final String methodAsString() {
        return this.method;
    }

    public final Document queryParameters() {
        return this.queryParameters;
    }

    public final Document body() {
        return this.body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.methodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeRestApiRequest)) {
            return false;
        }
        InvokeRestApiRequest other = (InvokeRestApiRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.methodAsString(), other.methodAsString()) && Objects.equals(this.queryParameters(), other.queryParameters()) && Objects.equals(this.body(), other.body());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeRestApiRequest").add("Name", (Object)this.name()).add("Path", (Object)this.path()).add("Method", (Object)this.methodAsString()).add("QueryParameters", (Object)this.queryParameters()).add("Body", (Object)(this.body() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Method": {
                return Optional.ofNullable(clazz.cast(this.methodAsString()));
            }
            case "QueryParameters": {
                return Optional.ofNullable(clazz.cast(this.queryParameters()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("Method", METHOD_FIELD);
        map.put("QueryParameters", QUERY_PARAMETERS_FIELD);
        map.put("Body", BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeRestApiRequest, T> g) {
        return obj -> g.apply((InvokeRestApiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaRequest.BuilderImpl
    implements Builder {
        private String name;
        private String path;
        private String method;
        private Document queryParameters;
        private Document body;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeRestApiRequest model) {
            super(model);
            this.name(model.name);
            this.path(model.path);
            this.method(model.method);
            this.queryParameters(model.queryParameters);
            this.body(model.body);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getMethod() {
            return this.method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        public final Builder method(RestApiMethod method) {
            this.method(method == null ? null : method.toString());
            return this;
        }

        public final Document getQueryParameters() {
            return this.queryParameters;
        }

        public final void setQueryParameters(Document queryParameters) {
            this.queryParameters = queryParameters;
        }

        @Override
        public final Builder queryParameters(Document queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        public final Document getBody() {
            return this.body;
        }

        public final void setBody(Document body) {
            this.body = body;
        }

        @Override
        public final Builder body(Document body) {
            this.body = body;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeRestApiRequest build() {
            return new InvokeRestApiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MwaaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeRestApiRequest> {
        public Builder name(String var1);

        public Builder path(String var1);

        public Builder method(String var1);

        public Builder method(RestApiMethod var1);

        public Builder queryParameters(Document var1);

        public Builder body(Document var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

