/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Apache Airflow log details for the log type (e.g. <code>DagProcessingLogs</code>).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModuleLoggingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ModuleLoggingConfiguration.Builder, ModuleLoggingConfiguration> {
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogGroupArn").getter(getter(ModuleLoggingConfiguration::cloudWatchLogGroupArn))
            .setter(setter(Builder::cloudWatchLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build())
            .build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(ModuleLoggingConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLevel").getter(getter(ModuleLoggingConfiguration::logLevelAsString))
            .setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOG_GROUP_ARN_FIELD, ENABLED_FIELD, LOG_LEVEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cloudWatchLogGroupArn;

    private final Boolean enabled;

    private final String logLevel;

    private ModuleLoggingConfiguration(BuilderImpl builder) {
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.enabled = builder.enabled;
        this.logLevel = builder.logLevel;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache Airflow log type (e.g.
     * <code>DagProcessingLogs</code>) is published. For example,
     * <code>arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*</code>
     * .
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache Airflow log type (e.g.
     *         <code>DagProcessingLogs</code>) is published. For example,
     *         <code>arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*</code>
     *         .
     */
    public final String cloudWatchLogGroupArn() {
        return cloudWatchLogGroupArn;
    }

    /**
     * <p>
     * Indicates whether the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) is enabled.
     * </p>
     * 
     * @return Indicates whether the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The Apache Airflow log level for the log type (e.g. <code>DagProcessingLogs</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LoggingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The Apache Airflow log level for the log type (e.g. <code>DagProcessingLogs</code>).
     * @see LoggingLevel
     */
    public final LoggingLevel logLevel() {
        return LoggingLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * The Apache Airflow log level for the log type (e.g. <code>DagProcessingLogs</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LoggingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The Apache Airflow log level for the log type (e.g. <code>DagProcessingLogs</code>).
     * @see LoggingLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModuleLoggingConfiguration)) {
            return false;
        }
        ModuleLoggingConfiguration other = (ModuleLoggingConfiguration) obj;
        return Objects.equals(cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(logLevelAsString(), other.logLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModuleLoggingConfiguration").add("CloudWatchLogGroupArn", cloudWatchLogGroupArn())
                .add("Enabled", enabled()).add("LogLevel", logLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupArn()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "LogLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModuleLoggingConfiguration, T> g) {
        return obj -> g.apply((ModuleLoggingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModuleLoggingConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache Airflow log type (e.g.
         * <code>DagProcessingLogs</code>) is published. For example,
         * <code>arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*</code>
         * .
         * </p>
         * 
         * @param cloudWatchLogGroupArn
         *        The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache Airflow log type (e.g.
         *        <code>DagProcessingLogs</code>) is published. For example,
         *        <code>arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn);

        /**
         * <p>
         * Indicates whether the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the Apache Airflow log type (e.g. <code>DagProcessingLogs</code>) is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The Apache Airflow log level for the log type (e.g. <code>DagProcessingLogs</code>).
         * </p>
         * 
         * @param logLevel
         *        The Apache Airflow log level for the log type (e.g. <code>DagProcessingLogs</code>).
         * @see LoggingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggingLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * The Apache Airflow log level for the log type (e.g. <code>DagProcessingLogs</code>).
         * </p>
         * 
         * @param logLevel
         *        The Apache Airflow log level for the log type (e.g. <code>DagProcessingLogs</code>).
         * @see LoggingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggingLevel
         */
        Builder logLevel(LoggingLevel logLevel);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchLogGroupArn;

        private Boolean enabled;

        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ModuleLoggingConfiguration model) {
            cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            enabled(model.enabled);
            logLevel(model.logLevel);
        }

        public final String getCloudWatchLogGroupArn() {
            return cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        @Transient
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        @Transient
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        @Transient
        public final Builder logLevel(LoggingLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        @Override
        public ModuleLoggingConfiguration build() {
            return new ModuleLoggingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
