/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of the last update on the environment, and any errors that were encountered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LastUpdate implements SdkPojo, Serializable, ToCopyableBuilder<LastUpdate.Builder, LastUpdate> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(LastUpdate::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<UpdateError> ERROR_FIELD = SdkField.<UpdateError> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(LastUpdate::error)).setter(setter(Builder::error))
            .constructor(UpdateError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(LastUpdate::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LastUpdate::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, ERROR_FIELD,
            SOURCE_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final UpdateError error;

    private final String source;

    private final String status;

    private LastUpdate(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.error = builder.error;
        this.source = builder.source;
        this.status = builder.status;
    }

    /**
     * <p>
     * The day and time of the last update on the environment.
     * </p>
     * 
     * @return The day and time of the last update on the environment.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The error that was encountered during the last update of the environment.
     * </p>
     * 
     * @return The error that was encountered during the last update of the environment.
     */
    public final UpdateError error() {
        return error;
    }

    /**
     * <p>
     * The source of the last update to the environment. Includes internal processes by Amazon MWAA, such as an
     * environment maintenance update.
     * </p>
     * 
     * @return The source of the last update to the environment. Includes internal processes by Amazon MWAA, such as an
     *         environment maintenance update.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The status of the last update on the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the last update on the environment.
     * @see UpdateStatus
     */
    public final UpdateStatus status() {
        return UpdateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the last update on the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the last update on the environment.
     * @see UpdateStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastUpdate)) {
            return false;
        }
        LastUpdate other = (LastUpdate) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(error(), other.error())
                && Objects.equals(source(), other.source()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LastUpdate").add("CreatedAt", createdAt()).add("Error", error()).add("Source", source())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LastUpdate, T> g) {
        return obj -> g.apply((LastUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LastUpdate> {
        /**
         * <p>
         * The day and time of the last update on the environment.
         * </p>
         * 
         * @param createdAt
         *        The day and time of the last update on the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The error that was encountered during the last update of the environment.
         * </p>
         * 
         * @param error
         *        The error that was encountered during the last update of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(UpdateError error);

        /**
         * <p>
         * The error that was encountered during the last update of the environment.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateError.Builder} avoiding the need to create
         * one manually via {@link UpdateError#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateError.Builder#build()} is called immediately and its result
         * is passed to {@link #error(UpdateError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link UpdateError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(UpdateError)
         */
        default Builder error(Consumer<UpdateError.Builder> error) {
            return error(UpdateError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The source of the last update to the environment. Includes internal processes by Amazon MWAA, such as an
         * environment maintenance update.
         * </p>
         * 
         * @param source
         *        The source of the last update to the environment. Includes internal processes by Amazon MWAA, such as
         *        an environment maintenance update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The status of the last update on the environment.
         * </p>
         * 
         * @param status
         *        The status of the last update on the environment.
         * @see UpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the last update on the environment.
         * </p>
         * 
         * @param status
         *        The status of the last update on the environment.
         * @see UpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateStatus
         */
        Builder status(UpdateStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private UpdateError error;

        private String source;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LastUpdate model) {
            createdAt(model.createdAt);
            error(model.error);
            source(model.source);
            status(model.status);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final UpdateError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(UpdateError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        @Transient
        public final Builder error(UpdateError error) {
            this.error = error;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        @Transient
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(UpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public LastUpdate build() {
            return new LastUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
