/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.internal.UserAgentUtils;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse;

public class ListQualificationTypesIterable
implements SdkIterable<ListQualificationTypesResponse> {
    private final MTurkClient client;
    private final ListQualificationTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQualificationTypesIterable(MTurkClient client, ListQualificationTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQualificationTypesResponseFetcher();
    }

    public Iterator<ListQualificationTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListQualificationTypesResponseFetcher
    implements SyncPageFetcher<ListQualificationTypesResponse> {
        private ListQualificationTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListQualificationTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQualificationTypesResponse nextPage(ListQualificationTypesResponse previousPage) {
            if (previousPage == null) {
                return ListQualificationTypesIterable.this.client.listQualificationTypes(ListQualificationTypesIterable.this.firstRequest);
            }
            return ListQualificationTypesIterable.this.client.listQualificationTypes((ListQualificationTypesRequest)((Object)ListQualificationTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

