/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HITStatus {
    ASSIGNABLE("Assignable"),
    UNASSIGNABLE("Unassignable"),
    REVIEWABLE("Reviewable"),
    REVIEWING("Reviewing"),
    DISPOSED("Disposed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HITStatus> VALUE_MAP;
    private final String value;

    private HITStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HITStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HITStatus> knownValues() {
        EnumSet<HITStatus> knownValues = EnumSet.allOf(HITStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HITStatus.class, HITStatus::toString);
    }
}

