/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.services.mturk.model.NotificationSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNotificationSettingsRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, UpdateNotificationSettingsRequest> {
    private static final SdkField<String> HIT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HITTypeId").getter(UpdateNotificationSettingsRequest.getter(UpdateNotificationSettingsRequest::hitTypeId)).setter(UpdateNotificationSettingsRequest.setter(Builder::hitTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITTypeId").build()}).build();
    private static final SdkField<NotificationSpecification> NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Notification").getter(UpdateNotificationSettingsRequest.getter(UpdateNotificationSettingsRequest::notification)).setter(UpdateNotificationSettingsRequest.setter(Builder::notification)).constructor(NotificationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Active").getter(UpdateNotificationSettingsRequest.getter(UpdateNotificationSettingsRequest::active)).setter(UpdateNotificationSettingsRequest.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIT_TYPE_ID_FIELD, NOTIFICATION_FIELD, ACTIVE_FIELD));
    private final String hitTypeId;
    private final NotificationSpecification notification;
    private final Boolean active;

    private UpdateNotificationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.hitTypeId = builder.hitTypeId;
        this.notification = builder.notification;
        this.active = builder.active;
    }

    public final String hitTypeId() {
        return this.hitTypeId;
    }

    public final NotificationSpecification notification() {
        return this.notification;
    }

    public final Boolean active() {
        return this.active;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hitTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotificationSettingsRequest)) {
            return false;
        }
        UpdateNotificationSettingsRequest other = (UpdateNotificationSettingsRequest)((Object)obj);
        return Objects.equals(this.hitTypeId(), other.hitTypeId()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.active(), other.active());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateNotificationSettingsRequest").add("HITTypeId", (Object)this.hitTypeId()).add("Notification", (Object)this.notification()).add("Active", (Object)this.active()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITTypeId": {
                return Optional.ofNullable(clazz.cast(this.hitTypeId()));
            }
            case "Notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "Active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNotificationSettingsRequest, T> g) {
        return obj -> g.apply((UpdateNotificationSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String hitTypeId;
        private NotificationSpecification notification;
        private Boolean active;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotificationSettingsRequest model) {
            super(model);
            this.hitTypeId(model.hitTypeId);
            this.notification(model.notification);
            this.active(model.active);
        }

        public final String getHitTypeId() {
            return this.hitTypeId;
        }

        public final void setHitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
        }

        @Override
        @Transient
        public final Builder hitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
            return this;
        }

        public final NotificationSpecification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        public final void setNotification(NotificationSpecification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        @Override
        @Transient
        public final Builder notification(NotificationSpecification notification) {
            this.notification = notification;
            return this;
        }

        public final Boolean getActive() {
            return this.active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        @Transient
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotificationSettingsRequest build() {
            return new UpdateNotificationSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNotificationSettingsRequest> {
        public Builder hitTypeId(String var1);

        public Builder notification(NotificationSpecification var1);

        default public Builder notification(Consumer<NotificationSpecification.Builder> notification) {
            return this.notification((NotificationSpecification)((NotificationSpecification.Builder)NotificationSpecification.builder().applyMutation(notification)).build());
        }

        public Builder active(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

