/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.ConfigurationId;
import software.amazon.awssdk.services.mq.model.___listOfConfigurationIdCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Configurations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Configurations> {
    private static final SdkField<ConfigurationId> CURRENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Current").getter(Configurations.getter(Configurations::current)).setter(Configurations.setter(Builder::current)).constructor(ConfigurationId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("current").build()}).build();
    private static final SdkField<List<ConfigurationId>> HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("History").getter(Configurations.getter(Configurations::history)).setter(Configurations.setter(Builder::history)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("history").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConfigurationId> PENDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Pending").getter(Configurations.getter(Configurations::pending)).setter(Configurations.setter(Builder::pending)).constructor(ConfigurationId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pending").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_FIELD, HISTORY_FIELD, PENDING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Configurations.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ConfigurationId current;
    private final List<ConfigurationId> history;
    private final ConfigurationId pending;

    private Configurations(BuilderImpl builder) {
        this.current = builder.current;
        this.history = builder.history;
        this.pending = builder.pending;
    }

    public final ConfigurationId current() {
        return this.current;
    }

    public final boolean hasHistory() {
        return this.history != null && !(this.history instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationId> history() {
        return this.history;
    }

    public final ConfigurationId pending() {
        return this.pending;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.current());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHistory() ? this.history() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pending());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configurations)) {
            return false;
        }
        Configurations other = (Configurations)obj;
        return Objects.equals(this.current(), other.current()) && this.hasHistory() == other.hasHistory() && Objects.equals(this.history(), other.history()) && Objects.equals(this.pending(), other.pending());
    }

    public final String toString() {
        return ToString.builder((String)"Configurations").add("Current", (Object)this.current()).add("History", this.hasHistory() ? this.history() : null).add("Pending", (Object)this.pending()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Current": {
                return Optional.ofNullable(clazz.cast(this.current()));
            }
            case "History": {
                return Optional.ofNullable(clazz.cast(this.history()));
            }
            case "Pending": {
                return Optional.ofNullable(clazz.cast(this.pending()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("current", CURRENT_FIELD);
        map.put("history", HISTORY_FIELD);
        map.put("pending", PENDING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Configurations, T> g) {
        return obj -> g.apply((Configurations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConfigurationId current;
        private List<ConfigurationId> history = DefaultSdkAutoConstructList.getInstance();
        private ConfigurationId pending;

        private BuilderImpl() {
        }

        private BuilderImpl(Configurations model) {
            this.current(model.current);
            this.history(model.history);
            this.pending(model.pending);
        }

        public final ConfigurationId.Builder getCurrent() {
            return this.current != null ? this.current.toBuilder() : null;
        }

        public final void setCurrent(ConfigurationId.BuilderImpl current) {
            this.current = current != null ? current.build() : null;
        }

        @Override
        public final Builder current(ConfigurationId current) {
            this.current = current;
            return this;
        }

        public final List<ConfigurationId.Builder> getHistory() {
            List<ConfigurationId.Builder> result = ___listOfConfigurationIdCopier.copyToBuilder(this.history);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHistory(Collection<ConfigurationId.BuilderImpl> history) {
            this.history = ___listOfConfigurationIdCopier.copyFromBuilder(history);
        }

        @Override
        public final Builder history(Collection<ConfigurationId> history) {
            this.history = ___listOfConfigurationIdCopier.copy(history);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder history(ConfigurationId ... history) {
            this.history(Arrays.asList(history));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder history(Consumer<ConfigurationId.Builder> ... history) {
            this.history(Stream.of(history).map(c -> (ConfigurationId)((ConfigurationId.Builder)ConfigurationId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConfigurationId.Builder getPending() {
            return this.pending != null ? this.pending.toBuilder() : null;
        }

        public final void setPending(ConfigurationId.BuilderImpl pending) {
            this.pending = pending != null ? pending.build() : null;
        }

        @Override
        public final Builder pending(ConfigurationId pending) {
            this.pending = pending;
            return this;
        }

        public Configurations build() {
            return new Configurations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Configurations> {
        public Builder current(ConfigurationId var1);

        default public Builder current(Consumer<ConfigurationId.Builder> current) {
            return this.current((ConfigurationId)((ConfigurationId.Builder)ConfigurationId.builder().applyMutation(current)).build());
        }

        public Builder history(Collection<ConfigurationId> var1);

        public Builder history(ConfigurationId ... var1);

        public Builder history(Consumer<ConfigurationId.Builder> ... var1);

        public Builder pending(ConfigurationId var1);

        default public Builder pending(Consumer<ConfigurationId.Builder> pending) {
            return this.pending((ConfigurationId)((ConfigurationId.Builder)ConfigurationId.builder().applyMutation(pending)).build());
        }
    }
}

