/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The replication details of the data replication-enabled broker. Only returned if dataReplicationMode or
 * pendingDataReplicationMode is set to CRDR.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataReplicationMetadataOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<DataReplicationMetadataOutput.Builder, DataReplicationMetadataOutput> {
    private static final SdkField<DataReplicationCounterpart> DATA_REPLICATION_COUNTERPART_FIELD = SdkField
            .<DataReplicationCounterpart> builder(MarshallingType.SDK_POJO)
            .memberName("DataReplicationCounterpart")
            .getter(getter(DataReplicationMetadataOutput::dataReplicationCounterpart))
            .setter(setter(Builder::dataReplicationCounterpart))
            .constructor(DataReplicationCounterpart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationCounterpart").build())
            .build();

    private static final SdkField<String> DATA_REPLICATION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataReplicationRole").getter(getter(DataReplicationMetadataOutput::dataReplicationRole))
            .setter(setter(Builder::dataReplicationRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationRole").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_REPLICATION_COUNTERPART_FIELD, DATA_REPLICATION_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataReplicationCounterpart dataReplicationCounterpart;

    private final String dataReplicationRole;

    private DataReplicationMetadataOutput(BuilderImpl builder) {
        this.dataReplicationCounterpart = builder.dataReplicationCounterpart;
        this.dataReplicationRole = builder.dataReplicationRole;
    }

    /**
     * <p>
     * Describes the replica/primary broker. Only returned if this broker is currently set as a primary or replica in
     * the broker's dataReplicationRole property.
     * </p>
     * 
     * @return Describes the replica/primary broker. Only returned if this broker is currently set as a primary or
     *         replica in the broker's dataReplicationRole property.
     */
    public final DataReplicationCounterpart dataReplicationCounterpart() {
        return dataReplicationCounterpart;
    }

    /**
     * <p>
     * Defines the role of this broker in a data replication pair. When a replica broker is promoted to primary, this
     * role is interchanged.
     * </p>
     * 
     * @return Defines the role of this broker in a data replication pair. When a replica broker is promoted to primary,
     *         this role is interchanged.
     */
    public final String dataReplicationRole() {
        return dataReplicationRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationCounterpart());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataReplicationMetadataOutput)) {
            return false;
        }
        DataReplicationMetadataOutput other = (DataReplicationMetadataOutput) obj;
        return Objects.equals(dataReplicationCounterpart(), other.dataReplicationCounterpart())
                && Objects.equals(dataReplicationRole(), other.dataReplicationRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataReplicationMetadataOutput").add("DataReplicationCounterpart", dataReplicationCounterpart())
                .add("DataReplicationRole", dataReplicationRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataReplicationCounterpart":
            return Optional.ofNullable(clazz.cast(dataReplicationCounterpart()));
        case "DataReplicationRole":
            return Optional.ofNullable(clazz.cast(dataReplicationRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataReplicationMetadataOutput, T> g) {
        return obj -> g.apply((DataReplicationMetadataOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataReplicationMetadataOutput> {
        /**
         * <p>
         * Describes the replica/primary broker. Only returned if this broker is currently set as a primary or replica
         * in the broker's dataReplicationRole property.
         * </p>
         * 
         * @param dataReplicationCounterpart
         *        Describes the replica/primary broker. Only returned if this broker is currently set as a primary or
         *        replica in the broker's dataReplicationRole property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationCounterpart(DataReplicationCounterpart dataReplicationCounterpart);

        /**
         * <p>
         * Describes the replica/primary broker. Only returned if this broker is currently set as a primary or replica
         * in the broker's dataReplicationRole property.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataReplicationCounterpart.Builder}
         * avoiding the need to create one manually via {@link DataReplicationCounterpart#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataReplicationCounterpart.Builder#build()} is called immediately
         * and its result is passed to {@link #dataReplicationCounterpart(DataReplicationCounterpart)}.
         * 
         * @param dataReplicationCounterpart
         *        a consumer that will call methods on {@link DataReplicationCounterpart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationCounterpart(DataReplicationCounterpart)
         */
        default Builder dataReplicationCounterpart(Consumer<DataReplicationCounterpart.Builder> dataReplicationCounterpart) {
            return dataReplicationCounterpart(DataReplicationCounterpart.builder().applyMutation(dataReplicationCounterpart)
                    .build());
        }

        /**
         * <p>
         * Defines the role of this broker in a data replication pair. When a replica broker is promoted to primary,
         * this role is interchanged.
         * </p>
         * 
         * @param dataReplicationRole
         *        Defines the role of this broker in a data replication pair. When a replica broker is promoted to
         *        primary, this role is interchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationRole(String dataReplicationRole);
    }

    static final class BuilderImpl implements Builder {
        private DataReplicationCounterpart dataReplicationCounterpart;

        private String dataReplicationRole;

        private BuilderImpl() {
        }

        private BuilderImpl(DataReplicationMetadataOutput model) {
            dataReplicationCounterpart(model.dataReplicationCounterpart);
            dataReplicationRole(model.dataReplicationRole);
        }

        public final DataReplicationCounterpart.Builder getDataReplicationCounterpart() {
            return dataReplicationCounterpart != null ? dataReplicationCounterpart.toBuilder() : null;
        }

        public final void setDataReplicationCounterpart(DataReplicationCounterpart.BuilderImpl dataReplicationCounterpart) {
            this.dataReplicationCounterpart = dataReplicationCounterpart != null ? dataReplicationCounterpart.build() : null;
        }

        @Override
        public final Builder dataReplicationCounterpart(DataReplicationCounterpart dataReplicationCounterpart) {
            this.dataReplicationCounterpart = dataReplicationCounterpart;
            return this;
        }

        public final String getDataReplicationRole() {
            return dataReplicationRole;
        }

        public final void setDataReplicationRole(String dataReplicationRole) {
            this.dataReplicationRole = dataReplicationRole;
        }

        @Override
        public final Builder dataReplicationRole(String dataReplicationRole) {
            this.dataReplicationRole = dataReplicationRole;
            return this;
        }

        @Override
        public DataReplicationMetadataOutput build() {
            return new DataReplicationMetadataOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
