/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mpa.MpaAsyncClient;
import software.amazon.awssdk.services.mpa.internal.UserAgentUtils;
import software.amazon.awssdk.services.mpa.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.mpa.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.mpa.model.PolicyVersionSummary;

public class ListPolicyVersionsPublisher
implements SdkPublisher<ListPolicyVersionsResponse> {
    private final MpaAsyncClient client;
    private final ListPolicyVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPolicyVersionsPublisher(MpaAsyncClient client, ListPolicyVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPolicyVersionsPublisher(MpaAsyncClient client, ListPolicyVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPolicyVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPolicyVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PolicyVersionSummary> policyVersions() {
        Function<ListPolicyVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyVersions() != null) {
                return response.policyVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPolicyVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPolicyVersionsResponseFetcher
    implements AsyncPageFetcher<ListPolicyVersionsResponse> {
        private ListPolicyVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPolicyVersionsResponse> nextPage(ListPolicyVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyVersionsPublisher.this.client.listPolicyVersions(ListPolicyVersionsPublisher.this.firstRequest);
            }
            return ListPolicyVersionsPublisher.this.client.listPolicyVersions((ListPolicyVersionsRequest)((Object)ListPolicyVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

