/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mpa.MpaClient;
import software.amazon.awssdk.services.mpa.internal.UserAgentUtils;
import software.amazon.awssdk.services.mpa.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.mpa.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.mpa.model.PolicyVersionSummary;

public class ListPolicyVersionsIterable
implements SdkIterable<ListPolicyVersionsResponse> {
    private final MpaClient client;
    private final ListPolicyVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPolicyVersionsIterable(MpaClient client, ListPolicyVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPolicyVersionsResponseFetcher();
    }

    public Iterator<ListPolicyVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PolicyVersionSummary> policyVersions() {
        Function<ListPolicyVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyVersions() != null) {
                return response.policyVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPolicyVersionsResponseFetcher
    implements SyncPageFetcher<ListPolicyVersionsResponse> {
        private ListPolicyVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPolicyVersionsResponse nextPage(ListPolicyVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyVersionsIterable.this.client.listPolicyVersions(ListPolicyVersionsIterable.this.firstRequest);
            }
            return ListPolicyVersionsIterable.this.client.listPolicyVersions((ListPolicyVersionsRequest)((Object)ListPolicyVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

