/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SessionResponse {
    APPROVED("APPROVED"),
    REJECTED("REJECTED"),
    NO_RESPONSE("NO_RESPONSE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SessionResponse> VALUE_MAP;
    private final String value;

    private SessionResponse(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SessionResponse fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SessionResponse> knownValues() {
        EnumSet<SessionResponse> knownValues = EnumSet.allOf(SessionResponse.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SessionResponse.class, SessionResponse::toString);
    }
}

